% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{poismf_unsafe}
\alias{poismf_unsafe}
\title{Poisson factorization with no input casting}
\usage{
poismf_unsafe(A, B, Xcsr, Xcsc, k, ...)
}
\arguments{
\item{A}{Initial values for the user-factor matrix of dimensions [dimA, k],
assuming row-major order. Can be passed as a vector of dimension [dimA*k], or
as a matrix of dimension [k, dimA]. Note that R matrices use column-major order,
so if you want to pass an R matrix as initial values, you'll need to transpose it,
hence the shape [k, dimA]. Recommended to initialize `~ Gamma(1,1)`.
\bold{Will be modified in-place}.}

\item{B}{Initial values for the item-factor matrix of dimensions [dimB, k]. See
documentation about `A` for more details.}

\item{Xcsr}{The transpose of the `X` matrix in CSC format (so that its structure
would match a CSR matrix). Should be an object of class `Matrix::dgCMatrix`.}

\item{Xcsc}{The `X` matrix in CSC format. Should be an object of class `Matrix::dgCMatrix`.}

\item{k}{The number of latent factors. \bold{Must match with the dimension of `A` and `B`}.}

\item{...}{Other hyperparameters that can be passed to `poismf`. See the documentation
for \link{poismf} for details about possible hyperparameters. Init type and seed are
ignored as the `A` and `B` matrices are supposed to be passed already-initialized.}
}
\value{
A `poismf` model object. See the documentation for \link{poismf} for details.
}
\description{
This is a faster version of \link{poismf} which will not make any checks
or castings on its inputs. It is intended as a fast alternative when a model is to
be fit multiple times with different hyperparameters, and for allowing
custom-initialized factor matrices. \bold{Note that since it doesn't make any checks
or conversions, passing the wrong kinds of inputs or passing inputs with mismatching
dimensions will crash the R process}.

For most use cases, it's recommended to use the function `poismf` instead.
}
\seealso{
\link{poismf}
}
