% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poissonreg-package.R
\docType{package}
\name{poissonreg-package}
\alias{poissonreg}
\alias{poissonreg-package}
\title{parsnip methods for Poisson regression}
\description{
\pkg{poissonreg} offers a function to fit model to count data using Poisson
generalized linear models or via different methods for zero-inflated Poisson
(ZIP) models.
}
\details{
The model function works with the tidymodels infrastructure so that the model
can be resampled, tuned, tided, etc.
}
\section{Example}{
Let’s fit a model to the data from Agresti (2007) Table 7.6:\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(poissonreg)
library(tidymodels)
tidymodels_prefer()

log_lin_fit <-
  # Define the model
  poisson_reg() \%>\%
  # Choose an engine for fitting. The default is 'glm' so
  # this next line is not strictly needed:
  set_engine("glm") \%>\%
  # Fit the model to the data:
  fit(count ~ (.)^2, data = seniors)

log_lin_fit
}\if{html}{\out{</div>}}\preformatted{## parsnip model object
## 
## 
## Call:  stats::glm(formula = count ~ (.)^2, family = stats::poisson, 
##     data = data)
## 
## Coefficients:
##               (Intercept)               marijuanayes  
##                    5.6334                    -5.3090  
##              cigaretteyes                 alcoholyes  
##                   -1.8867                     0.4877  
## marijuanayes:cigaretteyes    marijuanayes:alcoholyes  
##                    2.8479                     2.9860  
##   cigaretteyes:alcoholyes  
##                    2.0545  
## 
## Degrees of Freedom: 7 Total (i.e. Null);  1 Residual
## Null Deviance:       2851 
## Residual Deviance: 0.374     AIC: 63.42
}

The different engines for the model that are provided by this package
are:\if{html}{\out{<div class="sourceCode r">}}\preformatted{show_engines("poisson_reg")
}\if{html}{\out{</div>}}\preformatted{## # A tibble: 5 × 2
##   engine   mode      
##   <chr>    <chr>     
## 1 glm      regression
## 2 hurdle   regression
## 3 zeroinfl regression
## 4 glmnet   regression
## 5 stan     regression
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tidymodels/poissonreg}
  \item \url{https://poissonreg.tidymodels.org/}
  \item Report bugs at \url{https://github.com/tidymodels/poissonreg/issues}
}

}
\author{
\strong{Maintainer}: Max Kuhn \email{max@rstudio.com} (\href{https://orcid.org/0000-0003-2402-136X}{ORCID})

Other contributors:
\itemize{
  \item RStudio [copyright holder, funder]
}

}
\keyword{internal}
