% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions__whenthen.R
\name{Expr_when_then_otherwise}
\alias{Expr_when_then_otherwise}
\alias{when}
\alias{then}
\alias{otherwise}
\title{when-then-otherwise Expr}
\arguments{
\item{predicate}{Into Expr into a boolean mask to branch by}

\item{expr}{Into Expr value to insert in when() or otherwise()}
}
\value{
Expr
}
\description{
Start a “when, then, otherwise” expression.
}
\details{
For the impl nerds: pl$when returns a whenthen object and whenthen returns whenthenthen, except
for otherwise(), which will terminate and return an Expr.
Otherwise may fail to return an Expr if e.g. two consecutive \code{when(x)$when(y)}
}
\examples{
df = pl$DataFrame(mtcars)
wtt =
  pl$when(pl$col("cyl") <= 4)$then("<=4cyl")$
    when(pl$col("cyl") <= 6)$then("<=6cyl")$
    otherwise(">6cyl")$alias("cyl_groups")
print(wtt)
df$with_columns(wtt)
}
\keyword{Expr}
