% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions__lazy.R
\name{pl_col}
\alias{pl_col}
\title{Start Expression with a column}
\arguments{
\item{name}{\itemize{
\item a single column by a string
\item all columns by using a wildcard \code{"*"}
\item multiple columns as vector of strings
\item column by regular expression if the regex starts with \code{^} and ends with \code{$}
e.g. pl$DataFrame(iris)$select(pl$col(c("^Sepal.*$")))
\item a single DataType or an R list of DataTypes, select any column of any such DataType
\item Series of utf8 strings abiding to above options
}}

\item{...}{Additional column names can be passed as strings, separated by commas.}
}
\value{
Column Expression
}
\description{
Return an expression representing a column in a DataFrame.
}
\examples{

df = pl$DataFrame(list(foo = 1, bar = 2L, foobar = "3"))

# a single column by a string
df$select(pl$col("foo"))

# two columns as strings separated by commas
df$select(pl$col("foo", "bar"))

# all columns by wildcard
df$select(pl$col("*"))
df$select(pl$all())

# multiple columns as vector of strings
df$select(pl$col(c("foo", "bar")))

# column by regular expression if the regex starts with `^` and ends with `$`
df$select(pl$col("^foo.*$"))

# a single DataType
df$select(pl$col(pl$dtypes$Float64))

# ... or an R list of DataTypes, select any column of any such DataType
df$select(pl$col(list(pl$dtypes$Float64, pl$dtypes$Utf8)))

# from Series of names
df$select(pl$col(pl$Series(c("bar", "foobar"))))
}
\keyword{Expr_new}
