% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_K}
\alias{get_K}
\title{Get Maximal Stages}
\usage{
get_K(object)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}
}
\value{
Integer.
}
\description{
\code{get_K} returns the maximal number of stages for the observations in
the policy data object.
}
\examples{
source(system.file("sim", "multi_stage.R", package="polle"))
d <- sim_multi_stage(5e2, seed = 1)
pd <- policy_data(data = d$stage_data,
                   baseline_data = d$baseline_data,
                   type = "long",
                   id = "id",
                   stage = "stage",
                   event = "event",
                   action = "A",
                   utility = "U")
pd
# getting the maximal number of stages:
get_K(pd)
}
