% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegistryFile.R
\docType{class}
\name{RegistryFile-class}
\alias{RegistryFile-class}
\alias{RegistryFile}
\title{Read, parse and modify registry file.}
\arguments{
\item{corpus}{name of the CWB corpus}

\item{new}{a new value to set}

\item{filename}{a filename}

\item{package}{name of a package}

\item{registry}{directory of the registry (defaults to CORPUS_Registry environment variable)}
}
\description{
The class includes methods to read, modify and write a registry file.
Several operations could be accomplished with the 'cwb-regedit' tool,
the functions defined here ensure that manipulating the registry is 
possible without a full installation of the CWB.
}
\details{
An appendix to the 'Corpus Encoding Tutorial' (http://cwb.sourceforge.net/files/CWB_Encoding_Tutorial.pdf)
includes an explanation of the registry file format.
}
\section{Fields}{

\describe{
\item{\code{registryDir}}{registry directory}

\item{\code{encoding}}{corpus encoding}

\item{\code{txt}}{registry as character vector}

\item{\code{pAttributes}}{p-attributes}

\item{\code{properties}}{corpus properties}

\item{\code{id}}{corpus id}

\item{\code{home}}{home directory}

\item{\code{name}}{corpus name}

\item{\code{info}}{path to info file}
}}

\section{Methods}{

\describe{
\item{\code{addPAttribute(pAttribute)}}{Add an p-attribute.}

\item{\code{addSAttribute(sAttribute)}}{Add an s-attribute.}

\item{\code{adjustHome()}}{Reset the home directory. This will usually be necessary after installing a data package.}

\item{\code{dropSAttribute(sAttribute)}}{Drop a s-attribute.}

\item{\code{getEncoding()}}{Get the encoding.}

\item{\code{getHome()}}{Get the home directory of a corpus.}

\item{\code{getId()}}{Get the id of a corpus.}

\item{\code{getInfo()}}{Get path to the info file.}

\item{\code{getName()}}{Get the name of a corpus.}

\item{\code{getPAttributes()}}{Get the pAttributes.}

\item{\code{getProperties()}}{Get corpus properties.}

\item{\code{getSAttributes()}}{Get the sAttributes.}

\item{\code{initialize(corpus = NULL, registry = Sys.getenv("CORPUS_REGISTRY"),
  package = NULL, filename = NULL)}}{Initialize a new RegistryFile object.}

\item{\code{parse()}}{Parse the registry file.}

\item{\code{read()}}{Read file from disc, as character vector in field 'txt'.}

\item{\code{setHome(new)}}{Set the home directory to a new location.}

\item{\code{setId(new)}}{Set the id of a corpus}

\item{\code{setProperty(property, value)}}{Set a corpus property.}

\item{\code{write(filename = NULL)}}{Write registry file to disk.}
}}

