% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngrams.R
\docType{methods}
\name{ngrams}
\alias{ngrams}
\alias{ngrams,partition-method}
\alias{ngrams,character-method}
\alias{ngrams,subcorpus-method}
\alias{ngrams,corpus-method}
\alias{ngrams,partition_bundle-method}
\title{Get N-Grams}
\usage{
ngrams(.Object, ...)

\S4method{ngrams}{partition}(.Object, n = 2, p_attribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{character}(.Object, n = 2, p_attribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{partition}(.Object, n = 2, p_attribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{subcorpus}(.Object, n = 2, p_attribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{character}(.Object, n = 2, p_attribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{corpus}(.Object, n = 2, p_attribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{partition_bundle}(.Object, n = 2, char = NULL,
  p_attribute = "word", mc = FALSE, progress = FALSE, ...)
}
\arguments{
\item{.Object}{object of class \code{partition}}

\item{...}{further parameters}

\item{n}{number of tokens/characters}

\item{p_attribute}{the p-attribute to use (can be > 1)}

\item{char}{if NULL, tokens will be counted, else characters, keeping only those provided by a character vector}

\item{progress}{logical}

\item{mc}{logical, whether to use multicore, passed into call to \code{blapply} (see respective documentation)}
}
\description{
Count n-grams, either of words, or of characters.
}
\examples{
use("polmineR")
P <- partition("GERMAPARLMINI", date = "2009-10-27")
ngramObject <- ngrams(P, n = 2, p_attribute = "word", char = NULL)

# a more complex scenario: get most frequent ADJA/NN-combinations
ngramObject <- ngrams(P, n = 2, p_attribute = c("word", "pos"), char = NULL)
ngramObject2 <- subset(
 ngramObject,
 ngramObject[["1_pos"]] == "ADJA"  & ngramObject[["2_pos"]] == "NN"
 )
ngramObject2@stat[, "1_pos" := NULL][, "2_pos" := NULL]
ngramObject3 <- sort(ngramObject2, by = "count")
head(ngramObject3)
}
