% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encoding}
\alias{encoding}
\alias{encoding<-}
\alias{encoding,missing-method}
\alias{encoding,textstat-method}
\alias{encoding,bundle-method}
\alias{encoding,character-method}
\alias{encoding,corpus-method}
\alias{encoding,subcorpus-method}
\title{Get and set encoding.}
\usage{
encoding(object)

encoding(object) <- value

\S4method{encoding}{missing}(object)

\S4method{encoding}{textstat}(object)

\S4method{encoding}{bundle}(object)

\S4method{encoding}{character}(object)

\S4method{encoding}{corpus}(object)

\S4method{encoding}{subcorpus}(object)
}
\arguments{
\item{object}{A \code{textstat} or \code{bundle} object (or an object
inheriting from these classes), or a length-one \code{character} vector
specifying a corpus. If missing, the method will return the session
character set.}

\item{value}{Value to be assigned.}
}
\value{
A length-one \code{character} vector with an encoding.
}
\description{
Method for \code{textstat} objects and classes inheriting from
\code{textstat}; if \code{object} is a character vector, the encoding of the
corpus is returned. If called without arguments, the session character set is
returned.
}
\details{
\code{encoding()} uses \code{l10n_info()} and \code{localeToCharset()} (in this
order) to determine the session encoding. If \code{localeToCharset()} returns
\code{NA}, "UTF-8" is assumed to be the session encoding.
}
\examples{
# Get session charset.
encoding()

# Get encoding of a corpus.
encoding("REUTERS")

# Get encoding of a partition.
r <- partition("REUTERS", places = "kuwait", regex = TRUE)
encoding(r)

# Get encoding of another class inheriting from textstat (count).
cnt <- count("REUTERS", p_attribute = "word")
encoding(cnt)

# Get encoding of objects in a bundle.
pb <- partition_bundle("REUTERS", s_attribute = "id")
encoding(pb)
}
