% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{assign_linkage_group}
\alias{assign_linkage_group}
\title{Assign non-SN markers to a linkage group and homologue(s).}
\usage{
assign_linkage_group(linkage_df, LG_hom_stack, SN_colname = "marker_a",
  unassigned_marker_name = "marker_b", phase_considered = "coupling",
  LG_number = 12, LOD_threshold = 3, ploidy = 4, assign_homologue = T,
  log = NULL)
}
\arguments{
\item{linkage_df}{A linkage \code{data.frame} as output of \code{\link{linkage}}.}

\item{LG_hom_stack}{A \code{data.frame} with markernames (\code{"SxN_Marker"}), linkage group (\code{"LG"}) and homologue (\code{"homologue"})}

\item{SN_colname}{The name of the column in linkage_df harbouring the 1.0 markers}

\item{unassigned_marker_name}{The name of the column in linkage_df harbouring the marker that are to be assigned.}

\item{phase_considered}{The phase that is used to assign the markers (deprecated)}

\item{LG_number}{The number of chromosomes (linkage groups) in the species.}

\item{LOD_threshold}{The LOD score at which a linkage to a linkage group is significant.}

\item{ploidy}{The ploidy of the plant species.}

\item{assign_homologue}{Logical. Should markers be assigned to homologues? If \code{FALSE} markers will be assigned to all homologues}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
Output is a data.frame with at least the following columns:
\item{Assigned_LG}{The assigned linkage group}
\item{Assigend_hom1}{The homologue with most linkages}
The columns LG1 - LGn and Hom1 - Homn give the number of hits per marker for that linkage group/homologue. Assigned_hom2 .. gives the nth homologue with most linkages.
}
\description{
\code{assign_linkage_group} quantifies per marker number of linkages to a linkage group and evaluates to which linkage group (and homologue(s)) the marker belongs.
}
\examples{
data("SN_DN_P1", "LGHomDf_P1_1")
assigned_df<-assign_linkage_group(linkage_df = SN_DN_P1,
                     LG_hom_stack = LGHomDf_P1_1,
                     LG_number = 5)
}
