% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_value_function.R
\name{plot_value_function}
\alias{plot_value_function}
\title{Plot the Value Function of a POMDP Solution}
\usage{
plot_value_function(
  model,
  projection = NULL,
  epoch = 1,
  ylim = NULL,
  legend = TRUE,
  col = NULL,
  lwd = 1,
  lty = 1,
  ...
)
}
\arguments{
\item{model}{a solved \link{POMDP}.}

\item{projection}{Sample in a projected belief space. See \code{\link[=projection]{projection()}} for details.}

\item{epoch}{the value function of what epoch should be plotted? Use 1 for
converged policies.}

\item{ylim}{the y limits of the plot.}

\item{legend}{logical; add a legend?}

\item{col}{potting colors.}

\item{lwd}{line width.}

\item{lty}{line type.}

\item{...}{additional arguments are passed on to \code{\link[stats:line]{stats::line()}}`.}
}
\value{
the function has no return value.
}
\description{
Plots the value function of a POMDP solution as a line plot. The solution is
projected on two states (i.e., the belief for the other states is held
constant at zero).
}
\examples{
data("Tiger")
sol <- solve_POMDP(model = Tiger)
sol

plot_value_function(sol, ylim = c(0,20))

## finite-horizon
sol <- solve_POMDP(model = Tiger, horizon = 3, discount = 1,
  method = "enum")
sol

plot_value_function(sol, epoch = 1, ylim = c(-5, 25))
plot_value_function(sol, epoch = 2, ylim = c(-5, 25))
plot_value_function(sol, epoch = 3, ylim = c(-5, 25))

\dontrun{
# using ggplot2 to plot the value function for epoch 3
library(ggplot2)
pol <- policy(sol)[[3]]
ggplot(pol) + 
 geom_segment(aes(x = 0, y = `tiger-left`, xend = 1, yend = `tiger-right`, color = action)) + 
 coord_cartesian(ylim = c(-5, 15)) + ylab("Reward") + xlab("Belief")
}
}
\seealso{
Other policy: 
\code{\link{estimate_belief_for_nodes}()},
\code{\link{optimal_action}()},
\code{\link{plot_belief_space}()},
\code{\link{plot_policy_graph}()},
\code{\link{policy}()},
\code{\link{projection}()},
\code{\link{reward}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()}

Other POMDP: 
\code{\link{POMDP_accessors}},
\code{\link{POMDP}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{update_belief}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{POMDP}
\concept{policy}
\keyword{hplot}
