% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_sumstats.R
\name{fixed}
\alias{fixed}
\title{Compute the fraction of sites fixed between populations}
\usage{
fixed(minor, total, nPops)
}
\arguments{
\item{minor}{is a matrix with the number of minor-allele reads. Each row of
the matrix is a different population and each column a different site.}

\item{total}{is a matrix with the total coverage. Each row of the matrix is a
different population and each column a different site.}

\item{nPops}{is an integer indicating the total number of populations.}
}
\value{
a numeric vector with a single entry when \code{nPops} is equal to 2 or
with three entries when \code{nPops} is set to 4.
}
\description{
This function will compute the fraction of sites that constitute a fixed
difference between populations.
}
\details{
More precisely, we define fixed differences as sites where the number of
minor-allele reads of a given population is equal to the total coverage of
that population and equal to zero in the other population.

For models with two populations, this function compares the two present-day
populations. For models with four populations, this function performs a
pairwise comparison of the populations at each of the locations. For the
models with four populations, we also assess the fraction of sites that
represent a fixed difference between any of the populations and the remaining
three populations.
}
\keyword{internal}
