% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{simulateCoverage}
\alias{simulateCoverage}
\title{Simulate total number of reads per site}
\usage{
simulateCoverage(mean, variance, nSNPs = NA, nLoci = NA, genotypes = NA)
}
\arguments{
\item{mean}{an integer that defines the mean depth of coverage to simulate.
Please note that this represents the mean coverage across all sites. If a
vector is supplied instead, the function assumes that each entry of the
vector is the mean for a different population.}

\item{variance}{an integer that defines the variance of the depth of coverage
across all sites. If a vector is supplied instead, the function assumes
that each entry of the vector is the variance for a different population.}

\item{nSNPs}{an integer representing the number of polymorphic sites per
locus to simulate. This is an optional input but either this or the
\code{genotypes} list must be supplied.}

\item{nLoci}{an optional integer that represents how many independent loci
should be simulated.}

\item{genotypes}{a list of simulated genotypes, where each entry is a matrix
corresponding to a different locus. At each matrix, each column is a
different SNP and each row is a different individual. This is an optional
input but either this or the \code{nSNPs} must be supplied.}
}
\value{
a list with the total coverage per population and per site. Each list
entry is a matrix corresponding to a different locus. For each matrix,
different rows represent different populations and each column is a
different site.
}
\description{
This function simulates the total number of reads, for each polymorphic site
using a negative binomial distribution.
}
\details{
The total number of reads is simulated with a negative binomial and according
to a user-defined mean depth of coverage and variance. This function is
intended to work with a list of genotypes, simulating the depth of coverage
for each site present in the genotypes. However, it can also be used to
simulate coverage distributions independent of genotypes, by choosing how
many loci to simulate (with the \code{nLoci} option) and choosing how many sites
per locus should be simulated (with the \code{nSNPs} option).
}
\examples{
# simulate 10 loci, each with 10 SNPs for a single population
simulateCoverage(mean = 100, variance = 250, nSNPs = 10, nLoci = 10)

# simulate 10 loci, each with 10 SNPs for two populations:
# the first with 100x and the second with 50x
simulateCoverage(mean = c(100, 50), variance = c(250, 150), nSNPs = 10, nLoci = 10)

# simulate coverage given a set of genotypes
# run scrm and obtain genotypes
genotypes <- run_scrm(nDip = 100, nloci = 10)
# simulate coverage
simulateCoverage(mean = 50, variance = 200, genotypes = genotypes)

}
