% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_H1}
\alias{compute_H1}
\alias{.compute_H1}
\title{compute_H1}
\usage{
.compute_H1(refcount, totcount, nblocks, block_id, verbose)
}
\arguments{
\item{refcount}{Matrix of nsnpxnpop with counts (genotype or reads) for the reference allele}

\item{totcount}{Matrix of nsnpxnpop with total counts or read coverages}

\item{nblocks}{Integer giving the number of block-jackknife blocs (may be 0 if no block-jackknife)}

\item{block_id}{Integer vector of length nsnps with the (0-indexed) id of the block to which each SNP belongs (-1 for SNPs outside blocks)}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a matrix with npops rows and nblocks+1 column giving the mean H1 of each pop within each block and for all SNPs (last column)
}
\description{
Compute (uncorrected) 1-Q1 for each block-jackknife block (if any) and over all the SNPs (i.e., either within or outside blocks)
}
\details{
Compute all the (uncorrected) H1=1-Q1 for each block-jackknife block (if any) and overall SNPs (within or outside blocks). 
It is indeed more convenient to compute H1 (rather than Q1) to apply corrections afterwards within R function
}
\examples{
#
}
