% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/where.R
\name{where}
\alias{where}
\title{Select variables with a function}
\usage{
where(fn)
}
\arguments{
\item{fn}{A function that returns \code{TRUE} or \code{FALSE}.}
}
\value{
A vector of \code{integer} column positions which are the result of the \code{fn} evaluation.
}
\description{
This selection helper selects the variables for which a function returns \code{TRUE}.
}
\examples{
iris \%>\% select(where(is.numeric))
iris \%>\% select(where(function(x) is.numeric(x)))
iris \%>\% select(where(function(x) is.numeric(x) && mean(x) > 3.5))

}
\seealso{
\link{select_helpers}
}
