% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{plot.survtab}
\alias{plot.survtab}
\title{\code{plot} method for survtab objects}
\usage{
\method{plot}{survtab}(x, y = NULL, subset = NULL, conf.int = NULL,
  col = NULL, lty = NULL, ylab = NULL, xlab = NULL, ...)
}
\arguments{
\item{x}{a \code{survtab} output object}

\item{y}{survival a character vector of variable names to plot;
e.g. \code{c("surv.obs","r.e2")}}

\item{subset}{a logical condition; \code{obj} is subset accordingly
before plotting}

\item{conf.int}{logical; if \code{TRUE}, adds any confidence intervals
present in \code{obj} for variables in \code{y}}

\item{col}{line colour; one value for each survival variable; will be recycled}

\item{lty}{line type; one value for each survival variable; will be recycled}

\item{ylab}{label for Y-axis}

\item{xlab}{label for X-axis}

\item{...}{additional arguments passed on to \code{plot} and
\code{lines.survtab}; e.g. \code{ylim} can be defined this way}
}
\description{
Plotting for \code{survtab} objects
}
\examples{
x <- lexpand(sire, fot=seq(0,5,1/12), status=status, pophaz=popmort)
st <- survtab(x)
plot(st, "r.e2")

plot(st, c("surv.obs", "r.e2"), conf.int=TRUE, col=1:2, xlim=c(0,5))
}
\author{
Joonas Miettinen
}

