% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popRFdemo.R
\name{popRFdemo}
\alias{popRFdemo}
\title{Function to demo the popRF package using WorldPop input data.}
\usage{
popRFdemo(project_dir, 
          country="NPL", 
          cores=0, 
          quant=TRUE, 
          ftp=TRUE, 
          verbose=TRUE, 
          log=TRUE, ...)
}
\arguments{
\item{project_dir}{Path to the folder to save the outputs.}

\item{country}{character. ISO of the country
(see \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{country codes}).
Default one is NPL (Nepal)}

\item{cores}{is a integer. Number of cores to use when executing the function.
If set to 0 \code{(max_number_of_cores - 1)}  will be used based on as
many processors as the hardware and RAM allow.
Default is \code{cores} = 0.}

\item{quant}{If FALSE then quant will not be calculated}

\item{ftp}{is logical. TRUE or FALSE: flag indicating whether
\href{ftp://ftp.worldpop.org}{FTP} or \href{https://data.worldpop.org}{HTTPS} of
\href{https://sdi.worldpop.org/wpdata}{WorldPop data} hub server will be used.
Default is \code{ftp} = TRUE.}

\item{verbose}{is logical. TRUE or FALSE: flag indicating whether to print
intermediate output from the function on the console, which might be
helpful for model debugging. Default is \code{verbose} = TRUE.}

\item{log}{is logical. TRUE or FALSE: flag indicating whether to print intermediate
output from the function on the log.txt file.
Default is \code{log} = FALSE.}

\item{...}{Additional arguments:\cr
\code{binc}: Numeric. Increase number of blocks sugesting for
processing raster file.\cr
\code{boptimise}: Logical. Optimize total memory requires to
processing raster file by reducing the memory need to 35\%.\cr
\code{bsoft}: Numeric. If raster can be processed on less
then \code{cores} it will be foresed to use less number
of \code{cores}.\cr
\code{nodesize}: Minimum size of terminal nodes. Setting this number larger
causes smaller trees to be grown (and thus take less time). See
\code{\link[randomForest]{randomForest}} for more details. Default
is \code{nodesize} = NULL and will be calculated
as \code{length(y_data)/1000}.\cr
\code{maxnodes} Maximum number of terminal nodes trees in the forest can have.
If not given, trees are grown to the maximum possible (subject to
limits by nodesize). If set larger than maximum possible, a warning is
issued. See \code{\link[randomForest]{randomForest}} for more details.
Default is \code{maxnodes} = NULL.\cr
\code{ntree} Number of variables randomly sampled as candidates at each split.
See \code{\link[randomForest]{randomForest}} for more details.
Default is \code{ntree} = NULL and \code{ntree} will be used
\code{popfit$ntree}\cr
\code{mtry} Number of trees to grow. This should not be set to too small a
number, to ensure that every input row gets predicted at least a few
times. See \code{\link[randomForest]{randomForest}} for more details.
Default is \code{ntree} = NULL and \code{ntree} will be used
\code{popfit$mtry}.}
}
\value{
Raster* object of gridded population surfaces.
}
\description{
This function allows the user to generate a population layer
using the \href{https://www.worldpop.org}{WorldPop} geospatial covariates and
subnational census-based population estimates for 230 countries.
All input datasets use a geographical coordinate system (GCS) with WGS 1984
datum (EPSG:4326) in Geotiff format at a resolution of 3 arc-second
(0.00083333333 decimal degree, approximately 100m at the equator).
Mastergrid of sub-national administrative unit boundary was rasterised
by \href{http://www.ciesin.org}{CIESIN}.

Following covariates will be downloaded and used to disaggregat population
(2020 year) from census units into grid cells.
\itemize{
\item subnational_admin_2000_2020.tif  - sub-national units provided by  nationalEAs
\item esaccilc_dst011_2015.tif - Distance to ESA-CCI-LC cultivated area edges 2015.
\item esaccilc_dst040_2015.tif - Distance to ESA-CCI-LC woody-tree area edges 2015.
\item esaccilc_dst130_2015.tif - Distance to ESA-CCI-LC shrub area edges 2015.
\item esaccilc_dst140_2015.tif - Distance to ESA-CCI-LC herbaceous area edges 2015.
\item esaccilc_dst150_2015.tif - Distance to ESA-CCI-LC sparse vegetation area edges 2015.
\item esaccilc_dst160_2015.tif - Distance to ESA-CCI-LC aquatic vegetation area edges 2015.
\item esaccilc_dst190_2015.tif - Distance to ESA-CCI-LC artificial surface edges 2015.
\item esaccilc_dst200_2015.tif - Distance to ESA-CCI-LC bare area edges 2015.
\item esaccilc_dst_water_100m_2000_2012.tif - ESA-CCI-LC inland waterbodies 2000-2012.
\item coastline_100m_2000_2020.tif - Distance to coastline 2000-2020.
\item dst_roadintersec_100m_2016.tif - Distance to OSM major road intersections.
\item dst_waterway_100m_2016.tif - Distance to OSM major waterways.
\item dst_road_100m_2016.tif - Distance to OSM major roads.
\item px_area.tif - Grid-cell surface areas.
\item srtm_slope_100m.tif - SRTM-based slope 2000 (SRTM is Shuttle Radar Topography Mission).
\item srtm_topo_100m.tif - SRTM elevation 2000.
\item viirs_100m_2016.tif - VIIRS night-time lights 2015 (VIIRS is Visible Infrared Imaging Radiometer Suite).
\item wdpa_dst_cat1_100m_2017.tif - Distance to IUCN strict nature reserve and wilderness area edges 2017.
\item dst_bsgme_100m_2020.tif	- Distance to predicted built-settlement extents in 2020.
}
All downloaded files will be saved into subdirectory \code{covariates}.
}
\examples{
\dontrun{
popRFdemo(project_dir="/home/user/demo",
          country="NPL", 
          cores=0)
} 
}
\references{
\itemize{
\item Global spatio-temporally harmonised datasets for producing high-resolution
gridded population distribution datasets \doi{10.1080/20964471.2019.1625151}.
\item WorldPop (www.worldpop.org - School of Geography and Environmental Science,
University of Southampton; Department of Geography and Geosciences,
University of Louisville; Departement de Geographie, Universite de Namur)
and Center for International Earth Science Information Network (CIESIN),
Columbia University (2018). Global High Resolution Population Denominators
Project - Funded by The Bill and Melinda Gates Foundation (OPP1134076)
\doi{10.5258/SOTON/WP00649}.
}
}
