% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_rmse.R
\name{pp_rmse}
\alias{pp_rmse}
\title{RMS Error}
\usage{
pp_rmse(source, target, sourcecode, sourcepop, targetpop, title)
}
\arguments{
\item{source}{object of class \code{sf}}

\item{target}{object of class \code{sf}}

\item{sourcecode}{source zone id field}

\item{sourcepop}{source zone population field}

\item{targetpop}{target zone population field}

\item{title}{scatterplot title \code{string}}
}
\value{
a list including rms error, linear model details and correlation coefficient
}
\description{
This function calculates the rmse between the source and target counts
}
\examples{
    library(populR)
    data("target")
    data("source")

    # areametric
    pop_aw <- pp_estimate(source = source, target = target, sourcepop = 'pop',
        sourcecode = 'sid')

    # areametric rmse
    pp_rmse(target = pop_aw, source = source, sourcecode = 'sid',
        sourcepop = 'pop', targetpop = 'pp_est', title = 'Areametric')

    # volumetric
    pop_vw <- pp_estimate(source = source, target = target, sourcepop = 'pop',
        sourcecode = 'sid', volume = 'floors')

    # volumetric rmse
    pp_rmse(target = pop_vw, source = source, sourcecode = 'sid',
        sourcepop = 'pop', targetpop = 'pp_est', title = 'Volumetric')


}
