% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{marginal_settings-class}
\alias{marginal_settings-class}
\alias{marginal_settings}
\alias{show,marginal_settings-method}
\title{S4 class for the marginal settings}
\usage{
marginal_settings(
  train_size,
  refit_size,
  individual_spec = list(),
  default_spec = default_garch_spec()
)

\S4method{show}{marginal_settings}(object)
}
\arguments{
\item{train_size}{equivalent to the slot definition below}

\item{refit_size}{equivalent to the slot definition below}

\item{individual_spec}{equivalent to the slot definition below}

\item{default_spec}{equivalent to the slot definition below}

\item{object}{An object of class \code{marginal_settings}}
}
\value{
Object of class \code{marginal_settings}
}
\description{
Specify which marginal models (\code{individual_spec} & \code{default_specs}) are
fitted and how often they are refit as well as how big the training data
set is. Remember that the forecasting is done in a rolling window fashion
and the arguments (train and refit size) will have to match with
the arguments of the also to be specified \code{\link{vine_settings}}.
}
\details{
For specifying the list for \code{individual_spec} or the argument \code{default_spec}
the function \code{\link[=default_garch_spec]{default_garch_spec()}} might
come in handy.
}
\section{Functions}{
\itemize{
\item \code{marginal_settings}: Class constructor taking the arguments
specified in the slots below
}}

\section{Slots}{

\describe{
\item{\code{train_size}}{Positive count specifying the training data size.}

\item{\code{refit_size}}{Positive count specifying size of the forecasting
window.}

\item{\code{individual_spec}}{A named list. Specify ARMA-GARCH models for individual
assets by naming the list entry as the asset and providing a
\code{\link[rugarch:ugarchspec-methods]{rugarch::ugarchspec}} object.}

\item{\code{default_spec}}{\code{\link[rugarch:ugarchspec-methods]{rugarch::ugarchspec}}
object specifying the default marginal model (used if the marginal model
is not specified through \code{individual_spec})}
}}

\examples{
# the most basic initialization
marginal_settings(train_size = 100, refit_size = 10)
# some individualism
marginal_settings(
  train_size = 100, refit_size = 10,
  individual_spec = list("GOOG" = default_garch_spec(ar = 3)),
  default_spec = default_garch_spec(dist = "norm")
)
}
\seealso{
\code{\link[=default_garch_spec]{default_garch_spec()}}, \code{\link{vine_settings}}
}
