

#ifndef paramType_h
#define paramType_h

#include <variant>
#include <iterator>
#include <sstream>
#include <vector>
#include <set>
#include <map>
#include <memory>
#include <string>
#include <cstdint>

#include "myException.h"

class POSet;
class LinearExtensionGenerator;
class FunctionLinearExtension;
class Random;
class TranformExtension;

//************************************
//************************************
//************************************


typedef std::variant<
std::shared_ptr<std::map<std::uint64_t, std::string>>,
std::shared_ptr<std::vector<std::string>>,
std::shared_ptr<std::vector<std::uint64_t>>,
std::shared_ptr<Random>,

std::shared_ptr<std::vector<std::pair<std::string, std::string>>>,

std::shared_ptr<POSet>,
std::shared_ptr<std::vector<std::shared_ptr<FunctionLinearExtension>>>,
std::shared_ptr<LinearExtensionGenerator>,
std::shared_ptr<TranformExtension>,

std::shared_ptr<std::string>,
std::shared_ptr<std::uint64_t>,

std::shared_ptr<std::map<std::uint64_t, std::shared_ptr<std::set<std::uint64_t>>>>,

std::uint64_t
> ParamType;




#endif /* paramType_h */
