% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupClustering.R
\name{FormGroupsClusters}
\alias{FormGroupsClusters}
\title{Group effects given the pairwise p-values}
\usage{
FormGroupsClusters(
  PvaluesMatrix,
  CI = NULL,
  Effects,
  SignificanceLevel = 0.05,
  UpperCase = FALSE,
  RankLabels = TRUE,
  PlotAdj = FALSE,
  padjust = NULL,
  CalcClusters = FALSE,
  digits = 4
)
}
\arguments{
\item{PvaluesMatrix}{a matrix containing the p-values of the comparisons of
each possible pairs of effects in the lower triangle (excluding the diagonal)}

\item{CI}{a matrix containing with three columns containint the effects,
the lower limits and the upper limits of a confidence interval for the effects (default = NULL, indicating that no confidence intervals are available)}

\item{Effects}{a vector containing the effects}

\item{SignificanceLevel}{the significance level of the pairwise comparisons
(default = 0.05)}

\item{UpperCase}{should upper case letters be used for labelling the groups
(default is FALSE)}

\item{RankLabels}{should the labels of the grouping be sorted according to
the value of the response (default=TRUE)}

\item{PlotAdj}{should the associated graph be printed(default = FALSE)}

\item{padjust}{method for correcting the p-values (before the calculations
are performed) as in the function p.adjust (Default is NULL, indicating that no multiple testing corrections are used)}

\item{CalcClusters}{should the clusters be calculated and displayed
instead of grouping (Default is FALSE)}

\item{digits}{number of digits in the output (default = 4)}
}
\value{
an object of (S3) class "PostHoc" with methods for print, summary,
 plot, barplot and lines defined. An object of class "PostHoc" contails the
 effects, grouping, the matrix of p-values of all pairwise comparisons, the
 graph (Gr) of adjacency, the confidence intervals of the effects, the
 significance levels, the number of digits to be used for printing, the
 list of maximal cliques of the graph Gr, the clusters (if calculated).
}
\description{
Group effects given the pairwise p-values
}
\details{
This is an auxiliar function forming a contrast matrix of all
 possible. Generates an error if n is smaller than 2. The function
 contructs, using the supplied matrix of p-values for all pairwise
 comparisosns, an undirected graph with vertices representing the levels of
 the effects, using the convention that two vertices are connected by an
 edge iff the p-value for testing equality the two vertices is larger than
 the prefixed significance level. The maximal cliques of this graph form the
 grouping of the levels of the effects.
}
\examples{
MM <- glm(Y ~ Treatment+0,  data=DeIdentifiedExample)
GG <- posthoc(MM)
Effects <- coef(MM)
PvaluesMatrix <- GG$PvaluesMatrix
TT <- FormGroupsClusters(PvaluesMatrix = PvaluesMatrix, Effects = Effects)
plot(TT)
}
\author{
Rodrigo Labouriau
}
\keyword{pairwise-comparisons}
\keyword{post-hoc}
