% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_zones_all.R
\name{fetch_all}
\alias{fetch_all}
\title{Grab all the 3-digit origin-destination pairs.}
\usage{
fetch_all(origins = all_possible_origins, write_to = NULL, sleep_time = 1,
  n_tries = 3, as_range = FALSE, show_details = FALSE, verbose = TRUE)
}
\arguments{
\item{origins}{A vector of origin zips. Defaults to all possible origin zips from 000 to 999.}

\item{write_to}{The path to a CSV file to create and append each result to.}

\item{sleep_time}{How long to sleep in between requests, plus or minus \code{runif(1)} second.}

\item{n_tries}{How many times to try getting an origin if we're unsuccessful the first time?}

\item{as_range}{Do you want zones corresponding to a range of destination zips or a full listing of them?}

\item{show_details}{Should columns with more details be retained?}

\item{verbose}{Message what's going on?}
}
\value{
A tibble with origin zip and destination zips (in ranges or unspooled) and the USPS zones the origin-destination pair corresponds to.
}
\description{
Grab all the 3-digit origin-destination pairs.
}
\details{
For all the 3-digit origin zip codes, grab all destination zips and their corresponding zones. This is equivalent to running \code{fetch_zones_three_digit} for all possible 3 digit origin zips.

If this fails partway through, origins that could not be retrieved get a "no_success" value in their \code{dest_zip} and \code{zone} columns but we continue trying to grab results for all supplied \code{origins}.
}
\examples{
\dontrun{

fetch_all(sample(all_possible_origins, 4))

fetch_all(show_details = TRUE, verbose = TRUE,
    write_to = glue::glue(here::here("data", "{Sys.Date()}_zip_zones.csv")))
}

}
\seealso{
\link{fetch_zones_three_digit}
}
