% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterdown_html.R
\name{posterdown_html}
\alias{posterdown_html}
\alias{posterdown_betterland}
\alias{posterdown_betterport}
\title{Posterdown HTML format (using pagedown::poster_relaxed)}
\usage{
posterdown_html(..., template = find_resource("posterdown_html",
  "template.html"), css = NULL)

posterdown_betterland(...,
  template = find_resource("posterdown_betterland", "template.html"),
  css = NULL)

posterdown_betterport(...,
  template = find_resource("posterdown_betterport", "template.html"),
  css = NULL)
}
\arguments{
\item{...}{Additional arguments to \code{rmarkdown::html_document}}

\item{template}{See \code{\link{html_paged}()}.}

\item{css}{See \code{\link{html_paged}()}.}
}
\value{
R Markdown output format to pass to
\code{\link[rmarkdown:render]{rmarkdown::render()}}
}
\description{
The output format \code{poster_betterland()} mimics the style of the
BetterPoster movement from twitter.

The output format \code{poster_betterport()} mimics the style of the
BetterPoster movement from twitter.
}
\examples{
\donttest{
file <- file.path(tempdir(),"foo.rmd")
rmarkdown::draft(file, template="posterdown_html", package="posterdown")
}

}
