% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{variables}
\alias{variables}
\alias{variables.draws_matrix}
\alias{variables.draws_array}
\alias{variables.draws_df}
\alias{variables.draws_list}
\alias{variables.draws_rvars}
\alias{nvariables}
\title{Get variable names from \code{draws} objects}
\usage{
variables(x, ...)

\method{variables}{draws_matrix}(x, reserved = FALSE, with_indices = TRUE, ...)

\method{variables}{draws_array}(x, reserved = FALSE, with_indices = TRUE, ...)

\method{variables}{draws_df}(x, reserved = FALSE, with_indices = TRUE, ...)

\method{variables}{draws_list}(x, reserved = FALSE, with_indices = TRUE, ...)

\method{variables}{draws_rvars}(x, reserved = FALSE, with_indices = FALSE, ...)

nvariables(x, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{reserved}{(logical) Should reserved variables be included in the
output? Defaults to \code{FALSE}. See \code{\link{reserved_variables}} for an overview of
currently reserved variable names.}

\item{with_indices}{(logical) Should indices be included in variable
names? For example, if the object includes variables named \code{"x[1]"} and
\code{"x[2]"}, if \code{TRUE}, \code{c("x[1]", "x[2]")} is returned; if \code{FALSE}, only \code{"x"}
is returned. Defaults to \code{TRUE} for all formats except \code{\link[=draws_rvars]{draws_rvars()}}.}
}
\value{
For \code{variables()}, a character vector.

For \code{nvariables()}, a scalar integer.
}
\description{
Get variable names from \code{\link{draws}} objects.
}
\details{
\code{variables()} returns a vector of all variable names, and \code{nvariables()}
returns the number of variables.
}
\examples{
x <- example_draws()

variables(x)
nvariables(x)
variables(x) <- letters[1:nvariables(x)]
}
\seealso{
\code{\link{variables<-}}, \code{\link{rename_variables}}, \code{\link{draws-index}}
}
