#globalVariables(c("<<-", "internal", "xmin", "pars"))
# Intent:
#   This function suppresses the following notes generated by "R CMD check":
#   - "Note: no visible binding for '<<-' assignment to 'data'"
# See http://stackoverflow.com/q/23475309/203420
# suppressBindingNotes <- function(variablesMentionedInNotes) {
#   for(variable in variablesMentionedInNotes) {
#     assign(variable,NULL, envir = .GlobalEnv)       
#   }
# }
# suppressBindingNotes(c("dat", "internal", "xmin", "pars", "no_pars"))

#####################################################################
## Base R imports
#####################################################################
#' @import methods 
#' @import stats 
#' @import utils
#' @import graphics



distribution = setRefClass("distribution", 
                           fields=list(
                             dat = "ANY",
                             internal = "list", 
                             xmin = "ANY", 
                             pars="ANY",
                             no_pars="numeric"))

###############################
# Set get and set methods
# These will be inherited
###############################
distribution$accessors(c("xmin", "pars", "dat", "no_pars"))

#############################################################
# In the plotting functions we do slightly 
# different things for continuous and discrete distributions
#############################################################
discrete_distribution = setRefClass("discrete_distribution", contains="distribution")
ctn_distribution = setRefClass("ctn_distribution", contains="distribution")





