% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlnorm_rs.R
\name{rlnorm_rs}
\alias{rlnorm_rs}
\title{Random Variable From a Lognormal Distribution}
\usage{
rlnorm_rs(n = 10, mui = 0, sigma = 1, rev = FALSE, pmean = 0, psd = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{mui}{The parameter \code{mui} to
be used by \code{\link[stats:Lognormal]{stats::rlnorm()}}.}

\item{sigma}{The parameter \code{sigma} to
be used by \code{\link[stats:Lognormal]{stats::rlnorm()}}.}

\item{rev}{If TRUE, the distribution
is revered to generate a negatively
skewed distribution. Default is
FALSE.}

\item{pmean}{Population mean.}

\item{psd}{Population standard deviation.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from a lognormal distribution,
rescaled to have user-specified
population mean and standard
deviation.
}
\details{
First, specify the parameter,
\code{mui} and \code{sigma}, and the
desired population mean and standard
deviation. The random numbers, drawn
from a lognormal distribution by
\code{\link[stats:Lognormal]{stats::rlnorm()}}, will then be
rescaled with the desired population
mean and standard.
}
\examples{
set.seed(90870962)
x <- rlnorm_rs(n = 5000,
               mui = 0,
               sigma = 1,
               pmean = 0,
               psd = 1)
mean(x)
sd(x)
hist(x)

}
