% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_index_mome.R
\name{test_index_of_mome}
\alias{test_index_of_mome}
\title{Test a Moderated Mediation Effect}
\usage{
test_index_of_mome(
  fit = fit,
  x = NULL,
  m = NULL,
  y = NULL,
  w = NULL,
  mc_ci = TRUE,
  mc_out = NULL,
  boot_ci = FALSE,
  boot_out = NULL,
  check_post_check = TRUE,
  ...,
  fit_name = "fit",
  get_map_names = FALSE,
  get_test_name = FALSE
)
}
\arguments{
\item{fit}{The fit object, to be
passed to \code{\link[manymome:index_of_mome]{manymome::index_of_mome()}}.}

\item{x}{The name of the \code{x}-variable,
the predictor.}

\item{m}{A character vector of the
name(s) of mediator(s). The path
moves from the first mediator in the
vector to the last mediator in the
vector. Can be \code{NULL} and the path
is a direct path without mediator.}

\item{y}{The name of the \code{y}-variable,
the outcome variable.}

\item{w}{The name of the moderator.}

\item{mc_ci}{Logical. If \code{TRUE}, the
default, Monte Carlo confidence
intervals will be formed. This argument
and \code{boot_ci} cannot be both \code{TRUE}.}

\item{mc_out}{The pre-generated
Monte Carlo estimates generated by
\link[manymome:do_mc]{manymome::do_mc}, stored in
a \code{power4test} object. Users should
not set this argument and should let
\code{\link[=power4test]{power4test()}} to set it automatically.}

\item{boot_ci}{Logical. If \code{TRUE},
the default, nonparametric bootstrap
confidence intervals will be formed.
This argument
and \code{mc_ci} cannot be both \code{TRUE}.}

\item{boot_out}{The pre-generated
bootstrap estimates generated by
\link[manymome:do_boot]{manymome::do_boot}, stored in
a \code{power4test} object. Users should
not set this argument and should let
\code{\link[=power4test]{power4test()}} to set it automatically.}

\item{check_post_check}{Logical. If
\code{TRUE}, the default, and the model
is fitted by \code{lavaan}, the test
will be conducted only if the model
passes the \code{post.check} conducted
by \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} (with
\code{what = "post.check"}).}

\item{...}{Additional arguments to
be passed to \code{\link[manymome:index_of_mome]{manymome::index_of_mome()}}.}

\item{fit_name}{The name of the
model fit object to be extracted.
Default is \code{"fit"}. Used only when
more than one model is fitted in
each replication. This should be
the name of the model on which the
test is to be conducted.}

\item{get_map_names}{Logical. Used
by \code{\link[=power4test]{power4test()}} to determine how
to extract stored information and
assign them to this function. Users
should not use this argument.}

\item{get_test_name}{Logical. Used
by \code{\link[=power4test]{power4test()}} to get the default
name of this test. Users should not
use this argument.}
}
\value{
In its normal usage, it returns
a named numeric vector with the
following elements:
\itemize{
\item \code{est}: The mean of the estimated
indirect effect across datasets.
\item \code{cilo} and \code{cihi}: The means of the
lower and upper limits of the
confidence interval (95\% by
default), respectively.
\item \code{sig}: Whether a test by confidence
interval is significant (\code{1}) or
not significant (\code{0}).
}
}
\description{
Test a moderated
mediation effect for a \code{power4test}
object.
}
\details{
This function is to be used in
\code{\link[=power4test]{power4test()}} for testing a
moderated mediation effect, by
setting it to the \code{test_fun}
argument.

It uses \code{\link[manymome:index_of_mome]{manymome::index_of_mome()}}
to do the test. It can be used on
models fitted by \code{\link[lavaan:sem]{lavaan::sem()}}
or fitted by a sequence of calls
to \code{\link[stats:lm]{stats::lm()}}, although only
nonparametric bootstrap confidence
interval is supported for models
fitted by regression using
\code{\link[stats:lm]{stats::lm()}}.
}
\examples{

# Specify the model

mod <-
"
m ~ x + w + x:w
y ~ m
"

# Specify the population values

mod_es <-
"
m ~ x: n
y ~ x: m
m ~ w: l
m ~ x:w: l
"

# Simulate the data

sim_only <- power4test(nrep = 2,
                       model = mod,
                       pop_es = mod_es,
                       n = 100,
                       R = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Do the test in each replication

test_out <- power4test(object = sim_only,
                       test_fun = test_index_of_mome,
                       test_args = list(x = "x",
                                        m = "m",
                                        y = "y",
                                        w = "w",
                                        mc_ci = TRUE))

print(test_out,
      test_long = TRUE)

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
