% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_hadex_data.R
\name{test_hadex_data}
\alias{test_hadex_data}
\title{Apply tests for HaDeX data}
\usage{
test_hadex_data(
  dat,
  states = unique(dat[["State"]])[1:2],
  tests = list(test_houde)
)
}
\arguments{
\item{dat}{data.table. The data of hdx_data class from the HaDeX package.}

\item{states}{a character vector containing two states from provided `dat`
that should be tested. By default the first two states (if exist) from `dat`
are chosen.}

\item{tests}{a list of testing functions. In the `powerHaDeX` package the
following tests are implemented:

- \code{\link[powerHaDeX]{test_houde}},

- \code{\link[powerHaDeX]{test_hdx_analyzer}},

- \code{\link[powerHaDeX]{test_memhdx_model}},

-\code{\link[powerHaDeX]{test_semiparametric}}.}
}
\value{
This function returns a data table of variables:

- \code{Test} - name of test,

- \code{State_1}, \code{State_2} - tested states from \code{states},

- \code{Significant_difference} - \code{TRUE} or \code{FALSE}, indicating
whether the null hypothesis is rejected

- \code{Sequence} - amino acid sequence that was tested
}
\description{
This function converts the data from HaDeX in order to make it
compatible with the input of test functions and perform the testing
procedures of provided tests.
}
