% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slr.R
\name{slr}
\alias{slr}
\title{Power calculation for a simple linear regression}
\usage{
slr(
  N = NULL,
  beta10 = 0,
  beta1A = NULL,
  var.x = NULL,
  sigma.e = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{beta10}{The slope regression coefficient under the null hypothesis; defaults to 0.}

\item{beta1A}{The slope regression coefficient under the alternative hypothesis.}

\item{var.x}{The variance of the covariate X.}

\item{sigma.e}{The standard deviation of the error terms.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs sample size and power calculations for a simple linear regression.
Can solve for power, N or alpha. Required inputs include the values of the
slope regression coefficient under the null hypothesis and the alternative,
the variance of the covariate X, and the SD of the error. Power calculations
for a simple linear regression can also be conducted using the mlrF.overall function,
which requires fewer inputs.
}
\examples{
# Yi = beta0 + beta1 * Xi + ei, i = 1,...,N
slr(N = 100, beta10 = 1, beta1A = 1.5, var.x = 25, sigma.e = 10, sides = 1)
}
