% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAnimatedPPGM.R
\name{plotAnimatedPPGM}
\alias{plotAnimatedPPGM}
\title{plotAnimatedPPGM}
\usage{
plotAnimatedPPGM(envelope, tree, filename="ppgm.gif", which.biovars, 
path="", use.paleoclimate=TRUE, paleoclimateUser=NULL, layerAge=c(0:20))
}
\arguments{
\item{envelope}{the min and max envelope of each lineage for each time slice}

\item{tree}{the phylogeny or multiple phylogenies that show the relationship between species}

\item{filename}{desired filename of output}

\item{which.biovars}{A vector of the numbers of the bioclimate variables that should be returned. The bioclimate variables number correspond to the Hijmans table at (https://www.worldclim.org/data/bioclim.html).}

\item{path}{path to the directory where the results should be saved}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19. (see \code{getBioclimvars()}).}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}
}
\value{
An animated gif of species through time
}
\description{
This function creates an animated gif showing the change in modelled suitable habitat through time in geographic space.
}
\details{
Requires ImageMagick or GraphicsMagick to be installed on the operating system. This is easy to do if you have macports. Just type sudo port install ImageMagick into terminal.
}
\examples{
data(sampletrees)
data(occurrences)
tree <- sampletrees[[25]]
biooccu <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(biooccu[,4],biooccu$Species,min)
sp_data_max<- tapply(biooccu[,4],biooccu$Species,max)
treedata_min <- geiger::treedata(tree,sp_data_min,sort=TRUE,warnings=F)
treedata_max <- geiger::treedata(tree,sp_data_max,sort=TRUE,warnings=F)
\dontrun{full_est <- nodeEstimateEnvelopes(treedata_min,treedata_max)
node_est <- full_est$est
example_getEnvelopes <- getEnvelopes(treedata_min, treedata_max, node_est)
animatedplot <- plotAnimatedPPGM(example_getEnvelopes,tree,which.biovars=1,path=tempdir())}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard, Maria-Aleja Hurtado-Materon
}
