% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_lines.R
\name{draw_lines}
\alias{draw_lines}
\title{Draw straight lines on plot component}
\usage{
draw_lines(plot_component, args)
}
\arguments{
\item{plot_component}{String giving the name of the plot component to
draw on.}

\item{args}{A list of vectors giving arguments used for drawing
straight lines. See \link{praatpicture} documentation.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Helper function for adding straight lines to plot components made with
praatpicture. Do not use directly, instead use \link{praatpicture} with the
\code{draw_lines} argument.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, draw_lines=c('spectrogram',
h=seq(0,5000,by=1000), lty='dashed'))
}
