/*
 * Decompiled with CFR 0.152.
 */
package auc;

import auc.AUCCalculator;
import auc.PNPoint;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class Confusion
extends Vector<Object> {
    private static final long serialVersionUID = 1L;
    private double totPos;
    private double totNeg;

    public Confusion(double d, double d1) {
        if (d < 1.0 || d1 < 1.0) {
            this.totPos = 1.0;
            this.totNeg = 1.0;
            System.err.println("ERROR: " + d + "," + d1 + " - " + "Defaulting Confusion to 1,1");
        } else {
            this.totPos = d;
            this.totNeg = d1;
        }
    }

    public void addPRPoint(double d, double d1) throws NumberFormatException {
        if (d > 1.0 || d < 0.0 || d1 > 1.0 || d1 < 0.0) {
            throw new NumberFormatException();
        }
        double d2 = d * this.totPos;
        double d3 = (d2 - d1 * d2) / d1;
        PNPoint pnpoint = new PNPoint(d2, d3);
        if (!this.contains(pnpoint)) {
            this.add(pnpoint);
        }
    }

    public void addROCPoint(double d, double d1) throws NumberFormatException {
        if (d > 1.0 || d < 0.0 || d1 > 1.0 || d1 < 0.0) {
            throw new NumberFormatException();
        }
        double d2 = d1 * this.totPos;
        double d3 = d * this.totNeg;
        PNPoint pnpoint = new PNPoint(d2, d3);
        if (!this.contains(pnpoint)) {
            this.add(pnpoint);
        }
    }

    public void addPoint(double d, double d1) throws NumberFormatException {
        if (d < 0.0 || d > this.totPos || d1 < 0.0 || d1 > this.totNeg) {
            throw new NumberFormatException();
        }
        PNPoint pnpoint = new PNPoint(d, d1);
        if (!this.contains(pnpoint)) {
            this.add(pnpoint);
        }
    }

    public void sort() {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Sorting the datapoints !!! ---");
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to sort....");
            return;
        }
        Object[] apnpoint = new PNPoint[this.size()];
        int i = 0;
        while (this.size() > 0) {
            apnpoint[i++] = (PNPoint)this.elementAt(0);
            this.removeElementAt(0);
        }
        Arrays.sort(apnpoint);
        int j = 0;
        while (j < apnpoint.length) {
            this.add(apnpoint[j]);
            ++j;
        }
        PNPoint pnpoint = (PNPoint)this.elementAt(0);
        while (pnpoint.getPos() < 0.001 && pnpoint.getPos() > -0.001) {
            this.removeElementAt(0);
            pnpoint = (PNPoint)this.elementAt(0);
        }
        double d = pnpoint.getNeg() / pnpoint.getPos();
        PNPoint pnpoint1 = new PNPoint(1.0, d);
        if (!this.contains(pnpoint1) && pnpoint.getPos() > 1.0) {
            this.insertElementAt(pnpoint1, 0);
        }
        if (!this.contains(pnpoint1 = new PNPoint(this.totPos, this.totNeg))) {
            this.add(pnpoint1);
        }
    }

    public void interpolate() {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Interpolating New Points ---");
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to interpolate....");
            return;
        }
        int i = 0;
        while (i < this.size() - 1) {
            PNPoint pnpoint = (PNPoint)this.elementAt(i);
            PNPoint pnpoint1 = (PNPoint)this.elementAt(i + 1);
            double d = pnpoint1.getPos() - pnpoint.getPos();
            double d1 = pnpoint1.getNeg() - pnpoint.getNeg();
            double d2 = d1 / d;
            double d3 = pnpoint.getPos();
            double d4 = pnpoint.getNeg();
            while (Math.abs(pnpoint.getPos() - pnpoint1.getPos()) > 1.001) {
                double d5 = d4 + (pnpoint.getPos() - d3 + 1.0) * d2;
                PNPoint pnpoint2 = new PNPoint(pnpoint.getPos() + 1.0, d5);
                this.insertElementAt(pnpoint2, ++i);
                pnpoint = pnpoint2;
            }
            ++i;
        }
    }

    public double calculateAUCPR(double d) {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Calculating AUC-PR ---");
        }
        if (d < 0.0 || d > 1.0) {
            System.err.println("ERROR: invalid minRecall, must be between 0 and 1 - returning 0");
            return 0.0;
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to calculate....");
            return 0.0;
        }
        double d1 = d * this.totPos;
        int i = 0;
        PNPoint pnpoint = (PNPoint)this.elementAt(i);
        PNPoint pnpoint2 = null;
        try {
            while (pnpoint.getPos() < d1) {
                pnpoint2 = pnpoint;
                pnpoint = (PNPoint)this.elementAt(++i);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayindexoutofboundsexception) {
            System.out.println("ERROR: minRecall out of bounds - exiting...");
            System.exit(-1);
        }
        double d2 = (pnpoint.getPos() - d1) / this.totPos;
        double d3 = pnpoint.getPos() / (pnpoint.getPos() + pnpoint.getNeg());
        double d4 = d2 * d3;
        if (pnpoint2 != null) {
            double d5 = pnpoint.getPos() / this.totPos - pnpoint2.getPos() / this.totPos;
            double d6 = pnpoint.getPos() / (pnpoint.getPos() + pnpoint.getNeg()) - pnpoint2.getPos() / (pnpoint2.getPos() + pnpoint2.getNeg());
            double d8 = d6 / d5;
            double d10 = pnpoint2.getPos() / (pnpoint2.getPos() + pnpoint2.getNeg()) + d8 * (d1 - pnpoint2.getPos()) / this.totPos;
            double d12 = 0.5 * d2 * (d10 - d3);
            d4 += d12;
        }
        d2 = pnpoint.getPos() / this.totPos;
        int j = i + 1;
        while (j < this.size()) {
            PNPoint pnpoint3 = (PNPoint)this.elementAt(j);
            double d7 = pnpoint3.getPos() / this.totPos;
            double d9 = pnpoint3.getPos() / (pnpoint3.getPos() + pnpoint3.getNeg());
            double d11 = (d7 - d2) * d9;
            double d13 = 0.5 * (d7 - d2) * (d3 - d9);
            d4 += d11 + d13;
            d2 = d7;
            d3 = d9;
            ++j;
        }
        System.out.println("Area Under the Curve for Precision - Recall is " + d4);
        return d4;
    }

    public double calculateAUCROC() {
        if (AUCCalculator.DEBUG) {
            System.out.println("--- Calculating AUC-ROC ---");
        }
        if (this.size() == 0) {
            System.err.println("ERROR: No data to calculate....");
            return 0.0;
        }
        PNPoint pnpoint = (PNPoint)this.elementAt(0);
        double d = pnpoint.getPos() / this.totPos;
        double d1 = pnpoint.getNeg() / this.totNeg;
        double d2 = 0.5 * d * d1;
        int i = 1;
        while (i < this.size()) {
            PNPoint pnpoint2 = (PNPoint)this.elementAt(i);
            double d3 = pnpoint2.getPos() / this.totPos;
            double d4 = pnpoint2.getNeg() / this.totNeg;
            double d5 = (d3 - d) * d4;
            double d6 = 0.5 * (d3 - d) * (d4 - d1);
            d2 += d5 - d6;
            d = d3;
            d1 = d4;
            ++i;
        }
        d2 = 1.0 - d2;
        System.out.println("Area Under the Curve for ROC is " + d2);
        return d2;
    }

    public void writePRFile(String s) {
        System.out.println("--- Writing PR file " + s + " ---");
        if (this.size() == 0) {
            System.err.println("ERROR: No data to write....");
            return;
        }
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(new File(s)));
            int i = 0;
            while (i < this.size()) {
                PNPoint pnpoint = (PNPoint)this.elementAt(i);
                double d = pnpoint.getPos() / this.totPos;
                double d1 = pnpoint.getPos() / (pnpoint.getPos() + pnpoint.getNeg());
                printwriter.println(d + "\t" + d1);
                ++i;
            }
            printwriter.close();
        }
        catch (IOException ioexception) {
            System.out.println("ERROR: IO Exception in file " + s + " - exiting...");
            System.exit(-1);
        }
    }

    public void writeStandardPRFile(String s) {
        System.out.println("--- Writing standardized PR file " + s + " ---");
        if (this.size() == 0) {
            System.err.println("ERROR: No data to write....");
            return;
        }
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(new File(s)));
            int i = 0;
            PNPoint pnpoint = null;
            PNPoint pnpoint1 = (PNPoint)this.elementAt(i);
            double d = 1.0;
            while (d <= 100.0) {
                double d1 = pnpoint1.getPos() / this.totPos;
                double d2 = -1.0;
                if (d / 100.0 <= d1) {
                    if (pnpoint == null) {
                        d2 = pnpoint1.getPos() / (pnpoint1.getPos() + pnpoint1.getNeg());
                    } else {
                        double d3 = pnpoint1.getPos() - pnpoint.getPos();
                        double d5 = pnpoint1.getNeg() - pnpoint.getNeg();
                        double d7 = d5 / d3;
                        double d9 = d / 100.0 * this.totPos;
                        double d11 = pnpoint.getNeg() + (d9 - pnpoint.getPos()) * d7;
                        d2 = d9 / (d9 + d11);
                    }
                    printwriter.println(d / 100.0 + "\t" + d2);
                } else {
                    do {
                        pnpoint = pnpoint1;
                    } while (d / 100.0 > (d1 = (pnpoint1 = (PNPoint)this.elementAt(++i)).getPos() / this.totPos));
                    double d4 = pnpoint1.getPos() - pnpoint.getPos();
                    double d6 = pnpoint1.getNeg() - pnpoint.getNeg();
                    double d8 = d6 / d4;
                    double d10 = d / 100.0 * this.totPos;
                    double d12 = pnpoint.getNeg() + (d10 - pnpoint.getPos()) * d8;
                    d2 = d10 / (d10 + d12);
                    printwriter.println(d / 100.0 + "\t" + d2);
                }
                d += 1.0;
            }
            printwriter.close();
        }
        catch (IOException ioexception) {
            System.out.println("ERROR: IO Exception in file " + s + " - exiting...");
            System.exit(-1);
        }
    }

    public void writeROCFile(String s) {
        System.out.println("--- Writing ROC file " + s + " ---");
        if (this.size() == 0) {
            System.err.println("ERROR: No data to write....");
            return;
        }
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(new File(s)));
            printwriter.println("0\t0");
            int i = 0;
            while (i < this.size()) {
                PNPoint pnpoint = (PNPoint)this.elementAt(i);
                double d = pnpoint.getPos() / this.totPos;
                double d1 = pnpoint.getNeg() / this.totNeg;
                printwriter.println(d1 + "\t" + d);
                ++i;
            }
            printwriter.close();
        }
        catch (IOException ioexception) {
            System.out.println("ERROR: IO Exception in file " + s + " - exiting...");
            System.exit(-1);
        }
    }

    @Override
    public String toString() {
        String s = "";
        s = s + "TotPos: " + this.totPos + ", TotNeg: " + this.totNeg + "\n";
        int i = 0;
        while (i < this.size()) {
            s = s + this.elementAt(i) + "\n";
            ++i;
        }
        return s;
    }
}

