% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{gpe_rules_pre}
\alias{gpe_rules_pre}
\title{Get rule learner for gpe which mimics behavior of pre}
\usage{
gpe_rules_pre(learnrate = 0.01, par.init = FALSE, mtry = Inf,
  maxdepth = 3L, ntrees = 500, tree.control = ctree_control(),
  use.grad = TRUE, removeduplicates = TRUE, removecomplements = TRUE,
  tree.unbiased = TRUE)
}
\arguments{
\item{learnrate}{numeric value \eqn{> 0}. Learning rate or boosting parameter.}

\item{par.init}{logical. Should parallel foreach be used to generate initial 
ensemble? Only used when \verb{learnrate == 0}. Note: Must register parallel 
beforehand, such as doMC or others. Furthermore, setting 
\code{par.init = TRUE} will likely increase computation time for smaller 
datasets.}

\item{mtry}{positive integer. Number of randomly selected predictor variables for 
creating each split in each tree. Ignored when \code{tree.unbiased=FALSE}.}

\item{maxdepth}{positive integer. Maximum number of conditions in a rule. 
If length(maxdepth) == 1, it specifies the maximum depth of of each tree 
grown. If length(maxdepth) == ntrees, it specifies the maximum depth of 
every consecutive tree grown.}

\item{ntrees}{positive integer value. Number of trees to generate for the 
initial ensemble.}

\item{tree.control}{list with control parameters to be passed to the tree 
fitting function, generated using \code{\link[partykit]{ctree_control}},
\code{\link[partykit]{mob_control}} (if \code{use.grad = FALSE}), or 
\code{\link[rpart]{rpart.control}} (if \code{tree.unbiased = FALSE}).}

\item{use.grad}{logical. Should gradient boosting with regression trees be
employed when \code{learnrate > 0}? That is, use 
\code{\link[partykit]{ctree}} as in Friedman (2001), but without the line 
search. If \code{FALSE}. By default set to \code{TRUE}, as this yields shorter
computation times. If set to \code{FALSE}, \code{\link[partykit]{glmtree}}
with intercept only models in the nodes will be employed. This will yield
longer computation times, but may increase accuracy. See details below for 
possible combinations with \code{family}, \code{use.grad} and \code{learnrate}.}

\item{removeduplicates}{logical. Remove rules from the ensemble which are 
identical to an earlier rule?}

\item{removecomplements}{logical. Remove rules from the ensemble which are
identical to (1 - an earlier rule)?}

\item{tree.unbiased}{logical. Should an unbiased tree generation algorithm 
be employed for rule generation? Defaults to \code{TRUE}, if set to 
\code{FALSE}, rules will be generated employing the CART algorithm
(which suffers from biased variable selection) as implemented in 
\code{\link[rpart]{rpart}}. See details below for possible combinations 
with \code{family}, \code{use.grad} and \code{learnrate}.}
}
\description{
\code{gpe_rules_pre} generates a learner function which generates rules like 
pre, which can be supplied to the gpe base_learner argument
}
\examples{
\dontrun{
## Obtain same fits with pre and gpe
set.seed(42)
gpe.mod <- gpe(Ozone ~ ., data = airquality[complete.cases(airquality),],  
               base_learners = list(gpe_rules_pre(), gpe_linear()))
set.seed(42)
pre.mod <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),],)
}
}
