% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caret_pre_model.R
\docType{data}
\name{caret_pre_model}
\alias{caret_pre_model}
\title{Model set up for train function of package caret}
\format{An object of class \code{list} of length 17.}
\usage{
caret_pre_model
}
\description{
\code{caret_pre_model} provides a model setup for the train function of
package caret
}
\details{
This is still somewhat experimental. Function pre will become
availabel as a method in package caret in future versions, after additional 
testing and finetuning; caret_pre_model will then become depracated.
}
\examples{
\dontrun{
 
library("caret")

## Prepare data:
airq <- airquality[complete.cases(airquality),]
y <- airq$Ozone
x <- airq[,-1]

## Apply caret with only pre's default settings (trControl and ntrees argument
## are employed here only to reduce computation time):

# use default S3 method of train:
set.seed(42)
prefit1 <- train(x = x, y = y, method = caret_pre_model,
                 trControl = trainControl(number = 1),
                 ntrees = 25L)
prefit1

# use formula method for train:
set.seed(42)
prefit.f <- train(Ozone ~ ., data = airq, method = caret_pre_model,
                  trControl = trainControl(number = 1),
                  ntrees = 25L)
prefit.f

## Create custom tuneGrid:
set.seed(42)
tuneGrid <- caret_pre_model$grid(x = x, y = y,
                                 maxdepth = 3L:5L,
                                 learnrate = c(.01, .1),
                                 penalty.par.val = c("lambda.1se", "lambda.min"))
tuneGrid
## Apply caret (again, ntrees and trControl set only to reduce computation time):
prefit2 <- train(x = x, y = y, method = caret_pre_model,
                 trControl = trainControl(number = 1),
                 tuneGrid = tuneGrid, ntrees = 25L)
prefit2

## Get best tuning parameter values:
prefit2$bestTune
## Get predictions from model with best tuning parameters:
predict(prefit2, newdata = x[1:10, ])
plot(prefit2)

## Obtain tuning grid through random search over the tuning parameter space:
set.seed(42)
tuneGrid2 <- caret_pre_model$grid(x = x, y = y, search = "random", len = 10)
tuneGrid2
set.seed(42)
prefit3 <- train(x = x, y = y, method = caret_pre_model,
                 trControl = trainControl(number = 1, verboseIter = TRUE),
                 tuneGrid = tuneGrid2, ntrees = 25L)
prefit3

## Count response:
set.seed(42)
prefit4 <- train(x = x, y = y, method = caret_pre_model,
                 trControl = trainControl(number = 1),
                 ntrees = 25L, family = "poisson")
prefit4

## Binary factor response:
y_bin <- factor(airq$Ozone > mean(airq$Ozone))
set.seed(42)
prefit5 <- train(x = x, y = y_bin, method = caret_pre_model,
                 trControl = trainControl(number = 1),
                 ntrees = 25L, family = "binomial")
prefit5

## Factor response with > 2 levels:
x_multin <- airq[,-5]
y_multin <- factor(airq$Month)
set.seed(42)
prefit6 <- train(x = x_multin, y = y_multin, method = caret_pre_model,
                 trControl = trainControl(number = 1),
                 ntrees = 25L, family = "multinomial")
prefit6
}
}
\keyword{datasets}
