% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpe.R
\name{Cpe-class}
\alias{Cpe-class}
\alias{Cpe}
\title{An R6 base class for designs requiring Complete Path Enumeration}
\description{
An R6 base class for designs requiring Complete Path Enumeration

An R6 base class for designs requiring Complete Path Enumeration
}
\details{
TODO: Lots to be said here! The fundamental CPE concept has to be stated,
and implementation strategy discussed as well. If it turns out this class
ends up providing hooks for cacheing, this also needs to be detailed.
}
\note{
This state may in general decrease along a trial path,
as for example with BOIN's dose elimination. (Designs which
do not implement this safety feature may clarify this fact
by overriding (TODO: or deleting?) this method.

Concrete subclasses must implement this abstract method.

If the \code{parallel} package were to incorporate the necessary
changes to \code{mclapply}, I could restore the following import!
}
\references{
Norris DC. What Were They Thinking? Pharmacologic priors implicit in
a choice of 3+3 dose-escalation design. arXiv:2012.05301 [stat.ME].
December 2020. \url{https://arxiv.org/abs/2012.05301}
}
\seealso{
\code{path_matrix}, \code{path_table}, \code{path_array}.

\code{trace_paths}, which must already have been invoked
if this method is to return a meaningful result.

\code{trace_paths}, which must already have been invoked
if this method is to return a result.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{performance}}{A vector used for vetting performance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-max_dose}{\code{Cpe$max_dose()}}
\item \href{#method-bU}{\code{Cpe$bU()}}
\item \href{#method-J}{\code{Cpe$J()}}
\item \href{#method-applied}{\code{Cpe$applied()}}
\item \href{#method-report}{\code{Cpe$report()}}
\item \href{#method-trace_paths}{\code{Cpe$trace_paths()}}
\item \href{#method-path_matrix}{\code{Cpe$path_matrix()}}
\item \href{#method-path_array}{\code{Cpe$path_array()}}
\item \href{#method-path_probs}{\code{Cpe$path_probs()}}
\item \href{#method-path_rx}{\code{Cpe$path_rx()}}
\item \href{#method-clone}{\code{Cpe$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-max_dose"></a>}}
\if{latex}{\out{\hypertarget{method-max_dose}{}}}
\subsection{Method \code{max_dose()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$max_dose(D)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{D}}{A positive integer, the highest permissible dose.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set or query upper limit on further dosing
}

\subsection{Returns}{
Self (invisibly), unless \code{D} is missing,
in which case the top dose, an integer, is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bU"></a>}}
\if{latex}{\out{\hypertarget{method-bU}{}}}
\subsection{Method \code{bU()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$bU()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the \code{b} vector and \code{U} matrix
}

\subsection{Returns}{
Named list with components \code{b} and \code{U}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-J"></a>}}
\if{latex}{\out{\hypertarget{method-J}{}}}
\subsection{Method \code{J()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$J()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the number \code{J} of paths
}

\subsection{Returns}{
Integer number of paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-applied"></a>}}
\if{latex}{\out{\hypertarget{method-applied}{}}}
\subsection{Method \code{applied()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$applied(x, o, last_dose, max_dose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A dose-wise vector of toxicity counts}

\item{\code{o}}{A dose-wise vector of non-toxicity counts}

\item{\code{last_dose}}{The most recently given dose, as required to implement
cumulative-cohort-based escalation decisions.}

\item{\code{max_dose}}{An upper limit on future dose levels}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return dose recommendation for given tox/no-tox tallies.
}

\subsection{Returns}{
An object with components:
\itemize{
\item \verb{$stop} - logical value indicating whether stop is indicated
\item \verb{$mtd} - integer value, the recommended dose
\item \verb{$max_dose} - integer value, a dose not to be exceeded henceforth.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-report"></a>}}
\if{latex}{\out{\hypertarget{method-report}{}}}
\subsection{Method \code{report()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$report(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional columns to add to report}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Hook for concrete subclasses to implement for performance reporting
from method \code{Cpe$trace_paths}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trace_paths"></a>}}
\if{latex}{\out{\hypertarget{method-trace_paths}{}}}
\subsection{Method \code{trace_paths()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$trace_paths(root_dose, cohort_sizes, ..., prog = NULL, unroll = 4)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{root_dose}}{The starting dose for tree of paths}

\item{\code{cohort_sizes}}{Integer vector giving sizes of future cohorts,
its length being the maximum number of cohorts to look ahead.}

\item{\code{...}}{Parameters passed ultimately to \code{mclapply}, presently
an unexported, specially adapted version of \code{parallel::mclapply}
that implements progress reporting.}

\item{\code{prog}}{A function of a single integer, the current cumulative
path count, to be used for progress reporting}

\item{\code{unroll}}{Integer; how deep to unroll path tree for parallelism}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Compute trial paths forward from current tally

The computed paths are saved in a private field, from which variously
formatted results may be obtained by accessor functions.
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-path_matrix}{}}}
\subsection{Method \code{path_matrix()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$path_matrix()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Return computed trial paths in matrix form
}

\subsection{Returns}{
An integer matrix with the same column layout as the
DTP tables of \CRANpkg{dtpcrm}. That is, there is a D0 column
followed by paired Tc, Dc columns giving the toxicity count
for cohort c and the resulting dose recommendation \emph{yielded by}
cohort c -- which is generally the recommendation \emph{for} cohort
c+1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path_array"></a>}}
\if{latex}{\out{\hypertarget{method-path_array}{}}}
\subsection{Method \code{path_array()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$path_array(condense = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{condense}}{Logical value; if FALSE, the returned array has its
cohorts indexed trial-wise instead of dose-wise. This inflates the
array more than needed for the matrix computations it must support
(observe that in Norris2020c Eq. (4), the \code{c} index is eliminated
already by summation), but enables the sequence of events along a path
to be read off directly if this is required e.g. for visualization or
debugging. Default is TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return computed trial paths in a 3D array
}

\subsection{Returns}{
For the \code{j}th path, the C*D matrix \code{T[j,,]} gives
the number of toxicities \code{T[j,c,d]} occurring in the \code{c}th
cohort for dose d. In case \code{condense=FALSE}, see above.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path_probs"></a>}}
\if{latex}{\out{\hypertarget{method-path_probs}{}}}
\subsection{Method \code{path_probs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$path_probs(probs.DLT)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs.DLT}}{Numeric vector of DLT probabilities for the design's
prespecified doses.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Path probabilities for given dose-wise DLT probabilities

The design's paths must already have been completely enumerated by
\code{trace_paths}.
}

\subsection{Returns}{
A vector of probabilities for the enumerated paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path_rx"></a>}}
\if{latex}{\out{\hypertarget{method-path_rx}{}}}
\subsection{Method \code{path_rx()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$path_rx()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Vector of path-wise final dose recommendations

The design's paths must already have been completely enumerated by
\code{trace_paths}. This method is a temporizing measure, bridging
to a new format for the return value of \code{path_matrix}, possibly
a \code{data.table} where the dose recs would be a column.
}

\subsection{Returns}{
Integer vector of final dose recs on the enumerated paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cpe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
