% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/as.decade.r
\name{as.decade}
\alias{as.decade}
\alias{as.precintcon.decade}
\title{Convert a precipitation serie to a decade serie}
\usage{
as.decade(object)
}
\arguments{
\item{object}{a precintcon.daily, precintcon.monthly, precintcon.seasonal,
precintcon.annual object or a data.frame containing 33 or 3 columns.}
}
\value{
A data.frame (precintcon.decade) containing the following variables:
\itemize{
	\item \code{year} is the year.
\item \code{precipitation} is the decade's precipitation in millimeters.
}
}
\description{
Converts a daily, monthly, seasonal, or annual
precipitation serie to a decade serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Converting precipitation
as.monthly(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{as.precintcon.annual}}
\code{\link{as.precintcon.seasonal}}
\code{\link{as.precintcon.monthly}}
\code{\link{as.precintcon.daily}}
}
\keyword{decade}
\keyword{precipitation}

