% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{run_test}
\alias{run_test}
\title{Run a test}
\usage{
run_test(
  hook_name,
  file_name = hook_name,
  suffix = ".R",
  error_msg = NULL,
  cmd_args = NULL,
  copy = NULL
)
}
\arguments{
\item{hook_name}{The name of the hook in \verb{bin/}.}

\item{file_name}{The file to test in \verb{tests/in} (without extension).}

\item{suffix}{The suffix of \code{file_name}.}

\item{error_msg}{An expected error message. If no error is expected, this
can be \code{NULL}. In that case, the \code{comparator} is applied.}

\item{cmd_args}{More arguments passed to the file. Pre-commit handles it as
described \href{https://pre-commit.com/#arguments-pattern-in-hooks}{here}.}

\item{copy}{Path with files to copy to the temp directory where the test
is run. If the target destination relative to the temp dir where the hook
is tested is not identical to the path from where a file should be copied,
you can pass a named vector. The name is the target directory relative to
the temp directory where the hook is executed (the temp directory will be
the working directory at that time) and the value is the path that points
to the place where the artifact is currently stored.}
}
\description{
Tests for the executables used as pre-commit hooks via \code{entrypoint} in
\code{.pre-commit-config.yaml}.
}
\details{
Two potential outcomes of a hooks are pass or fail. This is reflected on the
level of the executable: Fail means the executable fails or the file is
changed. Pass means the executable succeeds and the file is unchanged.
We check if the executable passes as follows:
\itemize{
\item If we expect success (by setting \code{error_msg} to \code{NULL}), we make sure
nothing was written to sterr and the file content does not change.
\item If we expect failure, it can be due to changed file or due to failed
executable. To check for failed executalble, we set \code{error_msg} to
the message we expect. To check changed file content, we set \code{error_msg} to
\code{NA}.
}
}
\keyword{internal}
