% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_part.R
\name{part}
\alias{part}
\alias{part.sscurves}
\alias{part.mscurves}
\alias{part.smcurves}
\alias{part.mmcurves}
\title{Calculate partial AUCs}
\usage{
part(curves, xlim, ylim, curvetype)

\method{part}{sscurves}(curves, xlim = c(0, 1), ylim = c(0, 1), curvetype = c("ROC", "PRC"))

\method{part}{mscurves}(curves, xlim = c(0, 1), ylim = c(0, 1), curvetype = c("ROC", "PRC"))

\method{part}{smcurves}(curves, xlim = c(0, 1), ylim = c(0, 1), curvetype = c("ROC", "PRC"))

\method{part}{mmcurves}(curves, xlim = c(0, 1), ylim = c(0, 1), curvetype = c("ROC", "PRC"))
}
\arguments{
\item{curves}{An \code{S3} object generated by \code{\link{evalmod}}.
  The \code{part} function accepts the following S3 objects.

  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    sscurves \tab single   \tab single   \cr
    mscurves \tab multiple \tab single   \cr
    smcurves \tab single   \tab multiple \cr
    mmcurves \tab multiple \tab multiple
  }

   See the \strong{Value} section of \code{\link{evalmod}} for more details.}

\item{xlim}{A numeric vector of length two to specify x range between
two points in [0, 1]}

\item{ylim}{A numeric vector of length two to specify y range between
two points in [0, 1]}

\item{curvetype}{A character vector with the following curve types.
\tabular{ll}{
  \strong{curvetype} \tab \strong{description} \cr
  ROC \tab ROC curve \cr
  PRC \tab Precision-Recall curve
}
Multiple \code{curvetype} can be combined, such as
\code{c("ROC", "PRC")}.}
}
\value{
The \code{part} function returns the same S3 object specified as
  input with calculated pAUCs and standardized pAUCs.
}
\description{
The \code{part} function takes an \code{S3} object generated by
  \code{\link{evalmod}} and calculate partial AUCs and Standardized partial
  AUCs of ROC and Precision-Recall curves.
  Standardized pAUCs are standardized to the range between 0 and 1.
}
\examples{
\dontrun{

## Load library
library(ggplot2)

##################################################
### Single model & single test dataset
###

## Load a dataset with 10 positives and 10 negatives
data(P10N10)

## Generate an sscurve object that contains ROC and Precision-Recall curves
sscurves <- evalmod(scores = P10N10$scores, labels = P10N10$labels)

## Calculate partial AUCs
sscurves.part <- part(sscurves, xlim = c(0.25, 0.75))

## Show AUCs
sscurves.part

## Plot partial curve
plot(sscurves.part)

## Plot partial curve with ggplot
autoplot(sscurves.part)


##################################################
### Multiple models & single test dataset
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(1, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mscurves <- evalmod(mdat)

## Calculate partial AUCs
mscurves.part <- part(mscurves, xlim = c(0, 0.75), ylim = c(0.25, 0.75))

## Show AUCs
mscurves.part

## Plot partial curves
plot(mscurves.part)

## Plot partial curves with ggplot
autoplot(mscurves.part)


##################################################
### Single model & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(4, 100, 100, "good_er")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an smcurve object that contains ROC and Precision-Recall curves
smcurves <- evalmod(mdat)

## Calculate partial AUCs
smcurves.part <- part(smcurves, xlim = c(0.25, 0.75))

## Show AUCs
smcurves.part

## Plot partial curve
plot(smcurves.part)

## Plot partial curve with ggplot
autoplot(smcurves.part)


##################################################
### Multiple models & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(4, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mmcurves <- evalmod(mdat, raw_curves = TRUE)

## Calculate partial AUCs
mmcurves.part <- part(mmcurves, xlim = c(0, 0.25))

## Show AUCs
mmcurves.part

## Plot partial curves
plot(mmcurves.part)

## Plot partial curves with ggplot
autoplot(mmcurves.part)
}

}
\seealso{
\code{\link{evalmod}} for generating \code{S3} objects with
  performance evaluation measures. \code{\link{pauc}} for retrieving a dataset
  of pAUCs.
}
