% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{logit}
\alias{logit}
\title{Apply a logit transformation to an input}
\usage{
logit(p)
}
\arguments{
\item{p}{Numeric vector of probabilities (i.e. values between 0 and 1) that
will be transformed.}
}
\value{
A numeric vector, with values between -Inf and Inf
}
\description{
\code{logit} applies the logit transformation to convert a vector of values
between 0 and 1, to values between -Inf and Inf. Used to convert a
probability from a logistic regression model onto the linear predictor scale.
}
\examples{
logit(0.5)
logit(c(0.1, 0.2, 0.3))
}
\seealso{
\code{\link{inv_logit}}
}
