% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin.R
\name{kin}
\alias{kin}
\title{Calculate Kinship Matrix}
\usage{
kin(gen)
}
\arguments{
\item{gen}{a matrix for genotypes, coded as 1, 0, -1 for AA, Aa, aa. Each row represents an individual and each column represents a marker.}
}
\value{
a kinship matrix
}
\description{
Calculate the additive and dominance kinship matrix.
}
\examples{
## random population with 100 lines and 1000 markers
gen <- matrix(rep(0,100*1000),100,1000)
gen <- apply(gen,2,function(x){x <- sample(c(-1,0,1), 100, replace = TRUE)})

## generate 100*100 kinship matrix
k <- kin(gen)

}
