% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutpoint_methods.R
\name{get_thresholds}
\alias{get_thresholds}
\title{Gets probability thresholds given predicted probabilities, outcomes and NMB.}
\usage{
get_thresholds(predicted, actual, nmb, cutpoint_methods = NULL)
}
\arguments{
\item{predicted}{A vector of predicted probabilities.}

\item{actual}{A vector of actual outcomes.}

\item{nmb}{A named vector containing NMB assigned to true positives,
true negatives, false positives and false negatives}

\item{cutpoint_methods}{Which cutpoint method(s) to return.
The default (NULL) uses all the inbuilt methods.}
}
\value{
Returns a \code{list}.
}
\description{
Gets probability thresholds given predicted probabilities, outcomes and NMB.
}
\examples{

# get thresholds using default (all inbuilt) cutpoint methods
get_thresholds(
  predicted = runif(1000),
  actual = sample(c(0, 1), size = 1000, replace = TRUE),
  nmb = c("TP" = -3, "TN" = 0, "FP" = -1, "FN" = -4)
)


# get cutpoints using user-defined functions
# These functions must take the \code{predicted} and \code{actual}
# as arguments. They can also take \code{nmb} (named vector containing NMB
# with values for TP, FP, TN, FN).
fx_roc01 <- function(predicted, actual, ...) {
  cutpointr::cutpointr(
    x = predicted, class = actual, method = cutpointr::minimize_metric,
    metric = cutpointr::roc01,
    silent = TRUE
  )[["optimal_cutpoint"]]
}

fx_sum_sens_spec <- function(predicted, actual, ...) {
  cutpointr::cutpointr(
    x = predicted, class = actual, method = cutpointr::maximize_metric,
    metric = cutpointr::sum_sens_spec,
    silent = TRUE
  )[["optimal_cutpoint"]]
}

get_thresholds(
  predicted = runif(1000),
  actual = sample(c(0, 1), size = 1000, replace = TRUE),
  cutpoint_methods = c("fx_roc01", "fx_sum_sens_spec"),
  nmb = c("TP" = -3, "TN" = 0, "FP" = -1, "FN" = -4)
)

# get a combination of cutpoints from both user-defined functions and
# inbuilt methods
get_thresholds(
  predicted = runif(1000),
  actual = sample(c(0, 1), size = 1000, replace = TRUE),
  cutpoint_methods = c(
    "fx_roc01",
    "fx_sum_sens_spec",
    "youden",
    "all",
    "none"
  ),
  nmb = c("TP" = -3, "TN" = 0, "FP" = -1, "FN" = -4)
)
}
