% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/gcd.R
\name{gcd}
\alias{gcd}
\alias{scm}
\alias{lcm}
\alias{coprime}
\alias{Rgcd}
\alias{Rscm}
\title{Find the Greatest Common Divisor, Smallest Common Multiple, or Coprimality}
\usage{
gcd(m, n)

scm(m, n)

coprime(m, n)

Rgcd(...)

Rscm(...)
}
\arguments{
\item{m, n, ...}{integer vectors.}
}
\value{
The functions \code{gcd}, \code{scm}, and \code{coprime} return a vector of the
length of longest input vector. If one vector is shorter, it will be
recycled. The \code{gcd} and \code{scm} functions return an integer vector while
\code{coprime} returns a logical vector. The reduction funtions \code{Rgcd} and
\code{Rscm} return a single integer.
}
\description{
These functions provide vectorized computations for the greatest common
divisor (\code{gcd}), smallest common multiple (\code{scm}), and coprimality. Coprime
numbers are also called \emph{mutually prime} or \emph{relatively prime} numbers.
The smallest common multiple is often called the \emph{least common multiple}.
}
\details{
The greatest common divisor uses Euclid's algorithm, a fast and widely
used method. The smallest common multiple and coprimality are computed using
the gcd, where \eqn{scm = \frac{a}{gcd(a, b)} \times b}{scm = a / gcd(a, b) * b}
and two numbers are coprime when \eqn{gcd = 1}.

The \code{gcd}, \code{scm}, and \code{coprime} functions perform element-wise computation.
The \code{Rgcd} and \code{Rscm} functions perform \code{gcd} and \code{scm} over multiple values
using reduction. That is, they compute the greatest common divisor and least
common multiple for an arbitrary number of integers based on the properties
\eqn{gcd(a_1, a_2, ..., a_n) = gcd(gcd(a_1, a_2, ...), a_n)} and
\eqn{scm(a_1, a_2, ..., a_n) = scm(scm(a_1, a_2, ...), a_n)}. The binary
operation is applied to two elements; then the result is used as the first
operand in a call with the next element. This is done iteratively until all
elements are used. It is idiomatically equivalent to \code{Reduce(gcd, x)} or
\code{Reduce(scm, x)}, where \code{x} is a vector of integers, but much faster.
}
\examples{
gcd(c(18, 22, 49, 13), 42)
## [1] 6 2 7 1

Rgcd(18, 24, 36, 12)
## [1] 6

scm(60, 90)
## [1] 180

Rscm(1:10)
## [1] 2520

coprime(60, c(77, 90))
## [1]  TRUE FALSE
}
\author{
Paul Egeler, MS
}
