% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rsymphony_solver.R
\name{add_rsymphony_solver}
\alias{add_rsymphony_solver}
\alias{add_rsymphony_solver}
\title{Add a SYMPHONY solver with Rsymphony}
\usage{
add_rsymphony_solver(x, gap = 0.1, time_limit = -1, first_feasible = 0,
  verbose = TRUE)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative when
solving problems using \code{gurobi}, and will cause the optimizer to
terminate when the difference between the upper and lower objective
function bounds is less than the gap times the upper bound. For example, a
value of 0.01 will result in the optimizer stopping when the difference
between the bounds is 1 percent of the upper bound. But for other solvers
(e.g. \code{Rsymhpony}), this gap is absolute and expresses the acceptable
deviance from the optimal objective. For example, solving a
minimum set objective problem with a gap of 5 will cause the solver
to terminate when the cost of the solution is within 5 cost units
from the optimal solution.}

\item{time_limit}{\code{numeric} time limit in seconds to run the optimizer.
The solver will return the current best solution when this time limit is
exceeded.}

\item{first_feasible}{\code{logical} should the first feasible solution be
be returned? If \code{first_feasible} is set to \code{TRUE}, the solver
will return the first solution it encounters that meets all the
constraints, regardless of solution quality. Note that the first feasible
solution is not an arbitrary solution, rather it is derived from the
relaxed solution, and is therefore often reasonably close to optimality.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems? Defaults to \code{TRUE}.}
}
\description{
Specify the use of a SYMPHONY algorithm to solve a
\code{\link{ConservationProblem-class}} object. Requires the
\code{Rsymphony} package.
}
\details{
\href{https://projects.coin-or.org/SYMPHONY}{SYMPHONY} is an open-source
    integer programming solver that is part of the Computational
    Infrastructure for Operations Research (COIN-OR) project, an initiative
    to promote development of open-source tools for operations research (a
    field that includes linear programming). The \code{Rsymphony} package
    provides an interface to COIN-OR and is available on CRAN. This solver
    uses the \code{Rsymphony} package to solve problems.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions()
\donttest{
# if the package is installed then add solver and generate solution
if (requireNamespace("Rsymphony", quietly = TRUE)) {
  # specify solver and generate solution
  s <- p \%>\% add_rsymphony_solver(time_limit = 10) \%>\%
             solve()

  # plot solutions
  plot(stack(sim_pu_raster, s), main = c("planning units", "solution"),
       axes = FALSE, box = FALSE)
}
}

}
\seealso{
\code{\link{solvers}}.
}
