% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connected_matrix.R
\name{connected_matrix}
\alias{connected_matrix}
\alias{connected_matrix.Raster}
\alias{connected_matrix.SpatialPolygons}
\alias{connected_matrix.SpatialLines}
\alias{connected_matrix.SpatialPoints}
\alias{connected_matrix.default}
\title{Connected matrix}
\usage{
connected_matrix(x, ...)

\method{connected_matrix}{Raster}(x, directions = 4L, ...)

\method{connected_matrix}{SpatialPolygons}(x, ...)

\method{connected_matrix}{SpatialLines}(x, ...)

\method{connected_matrix}{SpatialPoints}(x, distance, ...)

\method{connected_matrix}{default}(x, ...)
}
\arguments{
\item{x}{\code{\link[raster]{Raster-class}} or
\code{\link[sp]{Spatial-class}} object. Note that if \code{x} is a
\code{\link[raster]{Raster-class}} object then it must have only one
layer.}

\item{...}{not used.}

\item{directions}{\code{integer} If \code{x} is a
\code{\link[raster]{Raster-class}} object, the number of directions
in which cells should be connected: 4 (rook's case), 8 (queen's case),
16 (knight and one-cell queen moves), or "bishop" to connect cells with
one-cell diagonal moves.}

\item{distance}{\code{numeric} If \code{x} is a
\code{\link{SpatialPoints-class}} object, the distance that planning units
have to be within in order to qualify as being connected.}
}
\value{
\code{\link[Matrix]{dsCMatrix-class}} object.
}
\description{
Create a matrix showing which planning units are spatially connected to
each other.
}
\details{
This function returns a \code{\link[Matrix]{dgCMatrix-class}} sparse
  matrix. Cells along the off-diagonal indicate if two planning units are
  connected. Cells along the diagonal are zero to reduce memory consumption.
  Note that for \code{\link[raster]{Raster-class}} arguments to \code{x},
  pixels with \code{NA} have zeros in the returned object to reduce
  memory consumption and be consistent with \code{\link{boundary_matrix}},
  and \code{\link{connectivity_matrix}}.
}
\examples{
# load data
data(sim_pu_raster, sim_pu_polygons, sim_pu_lines, sim_pu_points)

# create connected matrix using raster data
## crop raster to 9 cells
r <- crop(sim_pu_raster, c(0, 0.3, 0, 0.3))

## make connected matrix
cm_raster <- connected_matrix(r)

# create connected matrix using polygon data
## subset 9 polygons
ply <- sim_pu_polygons[c(1:2, 10:12, 20:22), ]

## make connected matrix
cm_ply <- connected_matrix(ply)

# create connected matrix using polygon line
## subset 9 lines
lns <- sim_pu_lines[c(1:2, 10:12, 20:22), ]

## make connected matrix
cm_lns <- connected_matrix(lns)

## create connected matrix using point data
## subset 9 points
pts <- sim_pu_points[c(1:2, 10:12, 20:22), ]

# make connected matrix
cm_pts <- connected_matrix(pts, distance = 0.1)

# plot data and the connected matrices
\donttest{
par(mfrow = c(4,2))

## plot raster and connected matrix
plot(r, main = "raster", axes = FALSE, box = FALSE)
plot(raster(as.matrix(cm_raster)), main = "connected matrix", axes = FALSE,
     box = FALSE)

## plot polygons and connected matrix
plot(r, main = "polygons", axes = FALSE, box = FALSE)
plot(raster(as.matrix(cm_ply)), main = "connected matrix", axes = FALSE,
    box = FALSE)

## plot lines and connected matrix
plot(r, main = "lines", axes = FALSE, box = FALSE)
plot(raster(as.matrix(cm_lns)), main = "connected matrix", axes = FALSE,
     box = FALSE)

## plot points and connected matrix
plot(r, main = "points", axes = FALSE, box = FALSE)
plot(raster(as.matrix(cm_pts)), main = "connected matrix", axes = FALSE,
     box = FALSE)
}
}
