% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/del_early_prov.R
\name{del_early_prov}
\alias{del_early_prov}
\title{Delete early / provisional PRISM data if replaced by provisional / stable data.}
\usage{
del_early_prov(type, minDate = NULL, maxDate = NULL, dates = NULL)
}
\arguments{
\item{type}{The type of data to download, must be "ppt", "tmean", "tmin", or "tmax".
Note that tmean == mean(tmin, tmax).}

\item{minDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date to start downloading data.
May be provided as either a character or \code{\link[base]{Date}} class.}

\item{maxDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date to end downloading data.
May be provided as either a character or \code{\link[base]{Date}} class.}

\item{dates}{a vector of iso-8601 formatted dates to download data for, can
also be a single date. May be provided as either a character or
\code{\link[base]{Date}} class.}
}
\description{
Searches the download folder for duplicated PRISM data
and keeps only the newest version.
}
