% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymize_locations.R
\name{anonymize_locations}
\alias{anonymize_locations}
\title{Anonymize Geographic Locations}
\usage{
anonymize_locations(
  x,
  method = c("remove", "generalize"),
  prefix = "Location",
  seed = NULL,
  use_uuid = TRUE
)
}
\arguments{
\item{x}{A character vector of locations to anonymize}

\item{method}{Character string specifying anonymization method:
"remove" (default) removes location information,
"generalize" replaces with generic location labels}

\item{prefix}{For "generalize" method: prefix for generic locations (default: "Location")}

\item{seed}{An optional seed for reproducible anonymization}

\item{use_uuid}{Logical, if TRUE uses short UUIDs instead of sequential IDs
(default: TRUE). Only applies when method = "generalize".}
}
\value{
A character vector of anonymized locations
}
\description{
Anonymizes geographic locations by removing them or replacing with generic
labels. Maintains referential integrity (same locations get the same value).
}
\examples{
locations <- c("New York, NY", "Los Angeles, CA", "Chicago, IL")
anonymize_locations(locations, method = "remove")
anonymize_locations(locations, method = "generalize", seed = 123)
anonymize_locations(locations, method = "generalize", 
                    use_uuid = FALSE, seed = 123)  # Use sequential IDs

}
