% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pps.R
\name{pps}
\alias{pps}
\title{Stratified probability-proportional-to-size sampling}
\usage{
pps(frame, stratid, nsamp, prn, size)
}
\arguments{
\item{frame}{Data frame (or data.table or tibble)
containing the elements to sample from.}

\item{stratid}{Variable in \code{frame} containing the strata.}

\item{nsamp}{Variable in \code{frame} containing the sample sizes.}

\item{prn}{Variable in \code{frame} containing the permanent random numbers.}

\item{size}{Variable in \code{frame} containing the size measure.}
}
\value{
A copy of the input sampling frame together with the boolean variable
\code{sampled}, indicating sample inclusion, as well as a numeric variable
\code{lambda} containing the estimated first-order inclusion probabilities
and the numeric variable \deqn{Q = \frac{prn(1 - lambda)}{lambda(1 - prn)}}
that determines which elements are sampled.
}
\description{
Stratified probability-proportional-to-size (Pareto PiPS) sampling using
permanent random numbers. Can also be used for non-stratified Pareto PiPS
using a dummy stratum taking the same value for each object.
}
\examples{
dfOut <- pps(
  frame = ExampleData,
  nsamp = ~nsample,
  stratid = ~stratum,
  prn = ~rands,
  size = ~sizeM
)
}
\seealso{
\link{prnsamplr}, \link{samp}, \link{srs}, \link{transformprn},
\link{ExampleData}
}
