% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCatVars.R
\name{addCatVars}
\alias{addCatVars}
\title{Add dummy vars to data.frame}
\usage{
addCatVars(df, varnames, groupLetter = "D", mode = 1)
}
\arguments{
\item{df}{A data.frame}

\item{varnames}{Variable name to be converted as factor and add dummies}

\item{groupLetter}{A character}

\item{mode}{Numeric. One of 1:4. 1= simple indicator coding, 2= sequential coding, 3= Helmert coding, 4= effect coding}
}
\description{
Add dummy vars to data.frame
}
\examples{
mtcars1=addCatVars(mtcars,c("cyl","carb"))
mtcars1[c(3:5),]
mtcars2=addCatVars(mtcars,c("cyl","carb"),mode=3)
mtcars2[c(3:5),]
protest1=addCatVars(protest,"protest")
head(protest1)
iris1=addCatVars(iris,c("Species"),mode=3)
(iris1[c(1,51,101),])
}
