% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains_exactly.R
\name{contains_exactly}
\alias{contains_exactly}
\title{Contains Exactly}
\usage{
contains_exactly(activity, n = 1)
}
\arguments{
\item{activity}{\code{\link{character}}: The activity to check. This should be an activity of the log supplied to \code{\link{check_rule}}.}

\item{n}{\code{\link{numeric}} (default \code{1}): The exact number of times the activity should be present.
Should be greater than or equal to \code{1}. Use \code{\link{absent}} instead to check for absent (i.e. \code{n = 0}) activities.}
}
\description{
Check if the specified activity is present (contained) in a case for exactly \code{n} times.

The \code{contains_exactly} rule examines whether the supplied \code{activity} is present in a case for an exact number of \code{n} times.
}
\examples{
library(bupaR)
library(eventdataR)

# Each patient should have exactly one registration activity instance.
patients \%>\%
 check_rule(contains_exactly("Registration", n = 1))

}
\seealso{
Other Cardinality rules: 
\code{\link{absent}()},
\code{\link{contains_between}()},
\code{\link{contains}()}
}
\concept{Cardinality rules}
