% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhmm_mmle.R
\name{compute_theta}
\alias{compute_theta}
\title{Estimate latent traits in LHMM}
\usage{
compute_theta(int_seqs, para_a, para_b, para_alpha, para_beta, para_P1, n_pts)
}
\arguments{
\item{int_seqs}{a list of \code{n} action sequences where actions are coded as integers 0, ..., N-1}

\item{para_a}{\code{K} by \code{K-1} matrix. discrimination parameters of state transition probability matrix}

\item{para_b}{\code{K} by \code{K-1} matrix. location parameters of state transition probability matrix}

\item{para_alpha}{\code{K} by \code{N-1} matrix. discrimination parameters of state-action (emission) probability matrix}

\item{para_beta}{\code{K} by \code{N-1} matrix. location parameters of state-action (emission) probability matrix}

\item{para_P1}{a vector of length \code{K-1}. parameters of initial state probability vector}

\item{n_pts}{number of quadrature points}
}
\value{
a vector of length \code{n}. Estimated latent traits.
}
\description{
Compute MAP estimates of latent traits given LHMM parameters
}
