% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-get.R
\name{getRatios}
\alias{getRatios}
\title{Get (Log-)ratios from Object}
\usage{
getRatios(object, cutoff = NA, include = NA, or = TRUE,
  melt = FALSE)
}
\arguments{
\item{object}{A \code{propr} or \code{propd} object.}

\item{cutoff}{This argument indicates the value at which to
cutoff the results. For "rho" and "cor", the function
returns pairs with a value greater than the cutoff.
For "theta", "phi", and "phs", the function returns pairs
with a value less than the cutoff. Leave the argument as
\code{NA} to return all results.}

\item{include}{This argument indicates which features by
name should belong to a pair for that pair to get included
in the results. Subset performed by
\code{Partner \%in\% subset | Pair \%in\% subset}.}

\item{or}{A boolean. If \code{FALSE}, \code{include} subsets
by \code{Partner \%in\% subset & Pair \%in\% subset}.}

\item{melt}{A boolean. Toggles whether to melt the results for
visualization with \code{ggplot2}.}
}
\value{
A \code{data.frame} of (log-)ratios.
}
\description{
This function provides a unified wrapper to retrieve (log-)ratios
 from \code{propr} and \code{propd} objects.
}
\details{
When the \code{alpha} argument is provided, this function returns
 the (log-)ratios as \code{(partner^alpha - pair^alpha) / alpha}.
}
